/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import com.google.common.base.Joiner;
import java.util.Arrays;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;

public class ListModel
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;

    public ListModel(CommandContext context, String metalake, String catalog, String schema) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
    }

    @Override
    public void handle() {
        NameIdentifier[] models = new NameIdentifier[]{};
        Namespace name = Namespace.of(this.schema);
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            models = client.loadCatalog(this.catalog).asModelCatalog().listModels(name);
        }
        catch (NoSuchMetalakeException noSuchMetalakeException) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException noSuchCatalogException) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException noSuchSchemaException) {
            this.exitWithError("Unknown schema name.");
        }
        catch (Exception err) {
            this.exitWithError(err.getMessage());
        }
        String output = models.length == 0 ? "No models exist." : Joiner.on(",").join(Arrays.stream(models).map(model -> model.name()).iterator());
        this.printResults(output);
    }
}

