/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.ranger;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.gravitino.authorization.AuthorizationPrivilege;
import org.apache.gravitino.authorization.Privilege;

public class RangerPrivileges {
    static List<Class<? extends Enum<? extends AuthorizationPrivilege>>> allRangerPrivileges = Lists.newArrayList((Object[])new Class[]{RangerHadoopSQLPrivilege.class, RangerHdfsPrivilege.class});

    public static AuthorizationPrivilege valueOf(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Privilege name string cannot be null!");
        String strPrivilege = name.trim().toLowerCase();
        for (Class<? extends Enum<? extends AuthorizationPrivilege>> enumClass : allRangerPrivileges) {
            for (Enum<? extends AuthorizationPrivilege> privilege : enumClass.getEnumConstants()) {
                if (!((AuthorizationPrivilege)privilege).equalsTo(strPrivilege)) continue;
                return (AuthorizationPrivilege)privilege;
            }
        }
        throw new IllegalArgumentException("Unknown privilege name: " + name);
    }

    public static class RangerHDFSPrivilegeImpl
    implements AuthorizationPrivilege {
        private AuthorizationPrivilege rangerHDFSPrivilege;
        private Privilege.Condition condition;

        public RangerHDFSPrivilegeImpl(AuthorizationPrivilege rangerHivePrivilege, Privilege.Condition condition) {
            this.rangerHDFSPrivilege = rangerHivePrivilege;
            this.condition = condition;
        }

        public String getName() {
            return this.rangerHDFSPrivilege.getName();
        }

        public Privilege.Condition condition() {
            return this.condition;
        }

        public boolean equalsTo(String value) {
            return this.rangerHDFSPrivilege.equalsTo(value);
        }
    }

    public static enum RangerHdfsPrivilege implements AuthorizationPrivilege
    {
        READ("read"),
        WRITE("write"),
        EXECUTE("execute");

        private final String name;

        private RangerHdfsPrivilege(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Privilege.Condition condition() {
            return null;
        }

        public boolean equalsTo(String value) {
            return this.name.equalsIgnoreCase(value);
        }
    }

    public static class RangerHivePrivilegeImpl
    implements AuthorizationPrivilege {
        private AuthorizationPrivilege rangerHivePrivilege;
        private Privilege.Condition condition;

        public RangerHivePrivilegeImpl(AuthorizationPrivilege rangerHivePrivilege, Privilege.Condition condition) {
            this.rangerHivePrivilege = rangerHivePrivilege;
            this.condition = condition;
        }

        public String getName() {
            return this.rangerHivePrivilege.getName();
        }

        public Privilege.Condition condition() {
            return this.condition;
        }

        public boolean equalsTo(String value) {
            return this.rangerHivePrivilege.equalsTo(value);
        }
    }

    public static enum RangerHadoopSQLPrivilege implements AuthorizationPrivilege
    {
        ALL("all"),
        SELECT("select"),
        UPDATE("update"),
        CREATE("create"),
        DROP("drop"),
        ALTER("alter"),
        INDEX("index"),
        LOCK("lock"),
        READ("read"),
        WRITE("write"),
        REPLADMIN("repladmin"),
        SERVICEADMIN("serviceadmin");

        private final String name;

        private RangerHadoopSQLPrivilege(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Privilege.Condition condition() {
            return null;
        }

        public boolean equalsTo(String value) {
            return this.name.equalsIgnoreCase(value);
        }
    }
}

