/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.shaded.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.hadoop.shaded.com.nimbusds.jose.shaded.json.JSONStyle;
import org.apache.hadoop.shaded.com.nimbusds.jose.shaded.json.parser.ContainerFactory;
import org.apache.hadoop.shaded.com.nimbusds.jose.shaded.json.parser.ContentHandler;
import org.apache.hadoop.shaded.com.nimbusds.jose.shaded.json.parser.ContentHandlerCompressor;
import org.apache.hadoop.shaded.com.nimbusds.jose.shaded.json.parser.FakeContainerFactory;
import org.apache.hadoop.shaded.com.nimbusds.jose.shaded.json.parser.JSONParser;
import org.apache.hadoop.shaded.com.nimbusds.jose.shaded.json.parser.ParseException;
import org.apache.hadoop.shaded.com.nimbusds.jose.shaded.json.reader.JsonWriter;
import org.apache.hadoop.shaded.com.nimbusds.jose.shaded.json.reader.JsonWriterI;

public class JSONValue {
    public static JSONStyle COMPRESSION = JSONStyle.NO_COMPRESS;
    private static final FakeContainerFactory FACTORY_FAKE_COINTAINER = new FakeContainerFactory();
    public static JsonWriter defaultWriter = new JsonWriter();

    public static Object parse(byte[] in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(byte[] in, int offset, int length) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, offset, length);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(InputStream in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(Reader in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(String s2) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(s2);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(byte[] in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(byte[] in, int offset, int length) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, offset, length, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(InputStream in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(Reader in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(String in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void SAXParse(InputStream input, ContentHandler handler) throws ParseException, IOException {
        JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        p.parse(input, (ContainerFactory)FACTORY_FAKE_COINTAINER, handler);
    }

    public static void SAXParse(Reader input, ContentHandler handler) throws ParseException, IOException {
        JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        p.parse(input, (ContainerFactory)FACTORY_FAKE_COINTAINER, handler);
    }

    public static void SAXParse(String input, ContentHandler handler) throws ParseException {
        JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        p.parse(input, (ContainerFactory)FACTORY_FAKE_COINTAINER, handler);
    }

    public static String compress(String input, JSONStyle style) {
        try {
            StringBuilder sb = new StringBuilder();
            ContentHandlerCompressor comp = new ContentHandlerCompressor(sb, style);
            JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            p.parse(input, (ContainerFactory)FACTORY_FAKE_COINTAINER, (ContentHandler)comp);
            return sb.toString();
        }
        catch (Exception e) {
            return input;
        }
    }

    public static String compress(String s2) {
        return JSONValue.compress(s2, JSONStyle.MAX_COMPRESS);
    }

    public static String uncompress(String s2) {
        return JSONValue.compress(s2, JSONStyle.NO_COMPRESS);
    }

    public static Object parseWithException(byte[] in) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseWithException(byte[] in, int offset, int length) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, offset, length, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseWithException(InputStream in) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseWithException(Reader in) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseWithException(String s2) throws ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(s2, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(InputStream in) throws IOException, ParseException {
        return new JSONParser(400).parse(in, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(Reader in) throws IOException, ParseException {
        return new JSONParser(400).parse(in, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(String s2) throws ParseException {
        return new JSONParser(400).parse(s2, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(byte[] s2) throws ParseException {
        return new JSONParser(400).parse(s2, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(byte[] s2, int offset, int length) throws ParseException {
        return new JSONParser(400).parse(s2, offset, length, ContainerFactory.FACTORY_SIMPLE);
    }

    public static boolean isValidJsonStrict(Reader in) throws IOException {
        try {
            new JSONParser(400).parse(in, (ContainerFactory)FACTORY_FAKE_COINTAINER);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidJsonStrict(String s2) {
        try {
            new JSONParser(400).parse(s2, (ContainerFactory)FACTORY_FAKE_COINTAINER);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidJson(Reader in) throws IOException {
        try {
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, (ContainerFactory)FACTORY_FAKE_COINTAINER);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidJson(String s2) {
        try {
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(s2, (ContainerFactory)FACTORY_FAKE_COINTAINER);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static void writeJSONString(Object value, Appendable out) throws IOException {
        JSONValue.writeJSONString(value, out, COMPRESSION);
    }

    public static void writeJSONString(Object value, Appendable out, JSONStyle compression) throws IOException {
        if (value == null) {
            out.append("null");
            return;
        }
        Class<?> clz = value.getClass();
        JsonWriterI<Object> w = defaultWriter.getWrite(clz);
        if (w == null) {
            if (clz.isArray()) {
                w = JsonWriter.arrayWriter;
            } else {
                w = defaultWriter.getWriterByInterface(value.getClass());
                if (w == null) {
                    w = JsonWriter.beansWriter;
                }
            }
            defaultWriter.registerWriter(w, clz);
        }
        w.writeJSONString(value, out, compression);
    }

    public static String toJSONString(Object value) {
        return JSONValue.toJSONString(value, COMPRESSION);
    }

    public static String toJSONString(Object value, JSONStyle compression) {
        StringBuilder sb = new StringBuilder();
        try {
            JSONValue.writeJSONString(value, sb, compression);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String escape(String s2) {
        return JSONValue.escape(s2, COMPRESSION);
    }

    public static String escape(String s2, JSONStyle compression) {
        if (s2 == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        compression.escape(s2, sb);
        return sb.toString();
    }

    public static void escape(String s2, Appendable ap) {
        JSONValue.escape(s2, ap, COMPRESSION);
    }

    public static void escape(String s2, Appendable ap, JSONStyle compression) {
        if (s2 == null) {
            return;
        }
        compression.escape(s2, ap);
    }
}

