/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.session;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.time.Duration;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.pool2.impl.BaseObjectPoolConfig;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.metrics.MetricsSystem;
import org.apache.gravitino.metrics.source.RelationDatasourceMetricsSource;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.CatalogMetaMapper;
import org.apache.gravitino.storage.relational.mapper.FilesetMetaMapper;
import org.apache.gravitino.storage.relational.mapper.FilesetVersionMapper;
import org.apache.gravitino.storage.relational.mapper.GroupMetaMapper;
import org.apache.gravitino.storage.relational.mapper.GroupRoleRelMapper;
import org.apache.gravitino.storage.relational.mapper.MetalakeMetaMapper;
import org.apache.gravitino.storage.relational.mapper.ModelMetaMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionAliasRelMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionMetaMapper;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.mapper.RoleMetaMapper;
import org.apache.gravitino.storage.relational.mapper.SchemaMetaMapper;
import org.apache.gravitino.storage.relational.mapper.SecurableObjectMapper;
import org.apache.gravitino.storage.relational.mapper.TableColumnMapper;
import org.apache.gravitino.storage.relational.mapper.TableMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TagMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TagMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.mapper.TopicMetaMapper;
import org.apache.gravitino.storage.relational.mapper.UserMetaMapper;
import org.apache.gravitino.storage.relational.mapper.UserRoleRelMapper;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;

public class SqlSessionFactoryHelper {
    private static volatile SqlSessionFactory sqlSessionFactory;
    private static final SqlSessionFactoryHelper INSTANCE;

    public static SqlSessionFactoryHelper getInstance() {
        return INSTANCE;
    }

    private SqlSessionFactoryHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(Config config) {
        BasicDataSource dataSource = new BasicDataSource();
        String jdbcUrl = config.get(Configs.ENTITY_RELATIONAL_JDBC_BACKEND_URL);
        JDBCBackend.JDBCBackendType jdbcType = JDBCBackend.JDBCBackendType.fromURI(jdbcUrl);
        dataSource.setUrl(jdbcUrl);
        dataSource.setDriverClassName(config.get(Configs.ENTITY_RELATIONAL_JDBC_BACKEND_DRIVER));
        dataSource.setUsername(config.get(Configs.ENTITY_RELATIONAL_JDBC_BACKEND_USER));
        dataSource.setPassword(config.get(Configs.ENTITY_RELATIONAL_JDBC_BACKEND_PASSWORD));
        dataSource.setDefaultAutoCommit(Boolean.valueOf(false));
        dataSource.setMaxWaitMillis(config.get(Configs.ENTITY_RELATIONAL_JDBC_BACKEND_WAIT_MILLISECONDS).longValue());
        dataSource.setMaxTotal(config.get(Configs.ENTITY_RELATIONAL_JDBC_BACKEND_MAX_CONNECTIONS).intValue());
        dataSource.setMaxIdle(5);
        dataSource.setMinIdle(0);
        dataSource.setLogAbandoned(true);
        dataSource.setRemoveAbandonedOnBorrow(true);
        dataSource.setRemoveAbandonedTimeout(60);
        dataSource.setTimeBetweenEvictionRunsMillis(Duration.ofMillis(600000L).toMillis());
        dataSource.setTestOnBorrow(true);
        dataSource.setTestWhileIdle(true);
        dataSource.setMinEvictableIdleTimeMillis(1000L);
        dataSource.setNumTestsPerEvictionRun(3);
        dataSource.setTestOnReturn(false);
        dataSource.setSoftMinEvictableIdleTimeMillis(BaseObjectPoolConfig.DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME.toMillis());
        dataSource.setLifo(true);
        MetricsSystem metricsSystem = GravitinoEnv.getInstance().metricsSystem();
        if (metricsSystem != null) {
            metricsSystem.register(new RelationDatasourceMetricsSource(dataSource));
        }
        JdbcTransactionFactory transactionFactory = new JdbcTransactionFactory();
        Environment environment = new Environment("development", (TransactionFactory)transactionFactory, (DataSource)dataSource);
        Configuration configuration = new Configuration(environment);
        configuration.setDatabaseId(jdbcType.name().toLowerCase());
        configuration.addMapper(MetalakeMetaMapper.class);
        configuration.addMapper(CatalogMetaMapper.class);
        configuration.addMapper(SchemaMetaMapper.class);
        configuration.addMapper(TableMetaMapper.class);
        configuration.addMapper(TableColumnMapper.class);
        configuration.addMapper(FilesetMetaMapper.class);
        configuration.addMapper(FilesetVersionMapper.class);
        configuration.addMapper(TopicMetaMapper.class);
        configuration.addMapper(UserMetaMapper.class);
        configuration.addMapper(RoleMetaMapper.class);
        configuration.addMapper(UserRoleRelMapper.class);
        configuration.addMapper(GroupMetaMapper.class);
        configuration.addMapper(GroupRoleRelMapper.class);
        configuration.addMapper(SecurableObjectMapper.class);
        configuration.addMapper(TagMetaMapper.class);
        configuration.addMapper(TagMetadataObjectRelMapper.class);
        configuration.addMapper(OwnerMetaMapper.class);
        configuration.addMapper(ModelMetaMapper.class);
        configuration.addMapper(ModelVersionMetaMapper.class);
        configuration.addMapper(ModelVersionAliasRelMapper.class);
        if (sqlSessionFactory != null) return;
        Class<SqlSessionFactoryHelper> clazz = SqlSessionFactoryHelper.class;
        synchronized (SqlSessionFactoryHelper.class) {
            if (sqlSessionFactory != null) return;
            sqlSessionFactory = new SqlSessionFactoryBuilder().build(configuration);
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return;
        }
    }

    public SqlSessionFactory getSqlSessionFactory() {
        Preconditions.checkState((sqlSessionFactory != null ? 1 : 0) != 0, (Object)"SqlSessionFactory is not initialized.");
        return sqlSessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() {
        if (sqlSessionFactory == null) return;
        Class<SqlSessionFactoryHelper> clazz = SqlSessionFactoryHelper.class;
        synchronized (SqlSessionFactoryHelper.class) {
            if (sqlSessionFactory == null) return;
            try {
                BasicDataSource dataSource = (BasicDataSource)sqlSessionFactory.getConfiguration().getEnvironment().getDataSource();
                dataSource.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            sqlSessionFactory = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        INSTANCE = new SqlSessionFactoryHelper();
    }
}

