/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import java.util.List;
import org.apache.gravitino.storage.relational.po.ModelVersionAliasRelPO;
import org.apache.ibatis.annotations.Param;

public class ModelVersionAliasRelBaseSQLProvider {
    public String insertModelVersionAliasRels(@Param(value="modelVersionAliasRel") List<ModelVersionAliasRelPO> modelVersionAliasRelPOs) {
        return "<script>INSERT INTO model_version_alias_rel (model_id, model_version, model_version_alias, deleted_at) VALUES  <foreach collection='modelVersionAliasRel' item='item' separator=','> (#{item.modelId}, (SELECT model_latest_version FROM model_meta WHERE model_id = #{item.modelId} AND deleted_at = 0), #{item.modelVersionAlias}, #{item.deletedAt}) </foreach></script>";
    }

    public String selectModelVersionAliasRelsByModelId(@Param(value="modelId") Long modelId) {
        return "SELECT model_id AS modelId, model_version AS modelVersion, model_version_alias AS modelVersionAlias, deleted_at AS deletedAt FROM model_version_alias_rel WHERE model_id = #{modelId} AND deleted_at = 0";
    }

    public String selectModelVersionAliasRelsByModelIdAndVersion(@Param(value="modelId") Long modelId, @Param(value="modelVersion") Integer modelVersion) {
        return "SELECT model_id AS modelId, model_version AS modelVersion, model_version_alias AS modelVersionAlias, deleted_at AS deletedAt FROM model_version_alias_rel WHERE model_id = #{modelId} AND model_version = #{modelVersion} AND deleted_at = 0";
    }

    public String selectModelVersionAliasRelsByModelIdAndAlias(@Param(value="modelId") Long modelId, @Param(value="alias") String alias) {
        return "SELECT model_id AS modelId, model_version AS modelVersion, model_version_alias AS modelVersionAlias, deleted_at AS deletedAt FROM model_version_alias_rel WHERE model_id = #{modelId} AND model_version = ( SELECT model_version FROM model_version_alias_rel WHERE model_id = #{modelId} AND model_version_alias = #{alias} AND deleted_at = 0) AND deleted_at = 0";
    }

    public String softDeleteModelVersionAliasRelsBySchemaIdAndModelName(@Param(value="schemaId") Long schemaId, @Param(value="modelName") String modelName) {
        return "UPDATE model_version_alias_rel mvar SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE mvar.model_id = ( SELECT mm.model_id FROM model_meta mm WHERE mm.schema_id = #{schemaId} AND mm.model_name = #{modelName} AND mm.deleted_at = 0) AND mvar.deleted_at = 0";
    }

    public String softDeleteModelVersionAliasRelsByModelIdAndVersion(@Param(value="modelId") Long modelId, @Param(value="modelVersion") Integer modelVersion) {
        return "UPDATE model_version_alias_rel SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE model_id = #{modelId} AND model_version = #{modelVersion} AND deleted_at = 0";
    }

    public String softDeleteModelVersionAliasRelsByModelIdAndAlias(@Param(value="modelId") Long modelId, @Param(value="alias") String alias) {
        return "UPDATE model_version_alias_rel mvar JOIN ( SELECT model_version FROM model_version_alias_rel WHERE model_id = #{modelId} AND model_version_alias = #{alias} AND deleted_at = 0) subquery ON mvar.model_version = subquery.model_version SET mvar.deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE mvar.model_id = #{modelId} AND mvar.deleted_at = 0";
    }

    public String softDeleteModelVersionAliasRelsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return "UPDATE model_version_alias_rel SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE model_id IN ( SELECT model_id FROM model_meta WHERE schema_id = #{schemaId} AND deleted_at = 0) AND deleted_at = 0";
    }

    public String softDeleteModelVersionAliasRelsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return "UPDATE model_version_alias_rel SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE model_id IN ( SELECT model_id FROM model_meta WHERE catalog_id = #{catalogId} AND deleted_at = 0) AND deleted_at = 0";
    }

    public String softDeleteModelVersionAliasRelsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE model_version_alias_rel SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE model_id IN ( SELECT model_id FROM model_meta WHERE metalake_id = #{metalakeId} AND deleted_at = 0) AND deleted_at = 0";
    }

    public String deleteModelVersionAliasRelsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM model_version_alias_rel WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }
}

