/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.gravitino.Configs;
import org.apache.gravitino.auth.AuthenticatorType;
import org.apache.gravitino.config.ConfigEntry;
import org.apache.gravitino.server.ServerConfig;
import org.apache.gravitino.server.authentication.OAuthConfig;
import org.apache.gravitino.server.web.ObjectMapperProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigServlet.class);
    private static final ImmutableSet<ConfigEntry<?>> oauthConfigEntries = ImmutableSet.of((Object)OAuthConfig.DEFAULT_SERVER_URI, (Object)OAuthConfig.DEFAULT_TOKEN_PATH);
    private static final ImmutableSet<ConfigEntry<?>> basicConfigEntries = ImmutableSet.of((Object)Configs.AUTHENTICATORS, (Object)Configs.ENABLE_AUTHORIZATION);
    private final Map<String, Object> configs = Maps.newHashMap();

    public ConfigServlet(ServerConfig serverConfig) {
        for (ConfigEntry key : basicConfigEntries) {
            this.configs.put(key.getKey(), serverConfig.get(key));
        }
        if (((List)serverConfig.get(Configs.AUTHENTICATORS)).contains(AuthenticatorType.OAUTH.name().toLowerCase())) {
            for (ConfigEntry key : oauthConfigEntries) {
                this.configs.put(key.getKey(), serverConfig.get(key));
            }
        }
        List visibleConfigs = (List)serverConfig.get(Configs.VISIBLE_CONFIGS);
        for (String config : visibleConfigs) {
            String configValue = serverConfig.getRawString(config);
            if (configValue == null) continue;
            this.configs.put(config, configValue);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IllegalStateException, IOException {
        try (PrintWriter writer = res.getWriter();){
            res.setContentType("application/json;charset=utf-8");
            writer.write(ObjectMapperProvider.objectMapper().writeValueAsString(this.configs));
        }
        catch (IllegalStateException exception) {
            LOG.error("Illegal state occurred when calling getWriter()");
        }
        catch (IOException exception) {
            LOG.error("Failed to perform IO");
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }
}

