/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.disk;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.paimon.disk.FileChannelManager;
import org.apache.paimon.disk.FileIOChannel;
import org.apache.paimon.utils.FileIOUtils;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChannelManagerImpl
implements FileChannelManager {
    private static final Logger LOG = LoggerFactory.getLogger(FileChannelManagerImpl.class);
    private final File[] paths;
    private final Random random;
    private final AtomicLong nextPath = new AtomicLong(0L);

    public FileChannelManagerImpl(String[] tempDirs, String prefix) {
        Preconditions.checkNotNull((Object)tempDirs, (String)"The temporary directories must not be null.");
        Preconditions.checkArgument((tempDirs.length > 0 ? 1 : 0) != 0, (Object)"The temporary directories must not be empty.");
        this.random = new Random();
        this.paths = FileChannelManagerImpl.createFiles(tempDirs, prefix);
    }

    private static File[] createFiles(String[] tempDirs, String prefix) {
        File[] files = new File[tempDirs.length];
        for (int i = 0; i < tempDirs.length; ++i) {
            File baseDir = new File(tempDirs[i]);
            String subfolder = String.format("paimon-%s-%s", prefix, UUID.randomUUID());
            File storageDir = new File(baseDir, subfolder);
            if (!storageDir.exists() && !storageDir.mkdirs()) {
                throw new RuntimeException("Could not create storage directory for FileChannelManager: " + storageDir.getAbsolutePath());
            }
            files[i] = storageDir;
            LOG.debug("FileChannelManager uses directory {} for spill files.", (Object)storageDir.getAbsolutePath());
        }
        return files;
    }

    @Override
    public FileIOChannel.ID createChannel() {
        int num = (int)(this.nextPath.getAndIncrement() % (long)this.paths.length);
        return new FileIOChannel.ID(this.paths[num], num, this.random);
    }

    @Override
    public FileIOChannel.Enumerator createChannelEnumerator() {
        return new FileIOChannel.Enumerator(this.paths, this.random);
    }

    @Override
    public File[] getPaths() {
        return Arrays.copyOf(this.paths, this.paths.length);
    }

    @Override
    public void close() throws Exception {
        IOUtils.closeAll((Iterable)Arrays.stream(this.paths).filter(File::exists).map(this::getFileCloser).collect(Collectors.toList()));
    }

    private AutoCloseable getFileCloser(File path) {
        return () -> {
            try {
                FileIOUtils.deleteDirectory((File)path);
                LOG.info("FileChannelManager removed spill file directory {}", (Object)path.getAbsolutePath());
            }
            catch (IOException e) {
                String errorMessage = String.format("FileChannelManager failed to properly clean up temp file directory: %s", path);
                throw new UncheckedIOException(errorMessage, e);
            }
        };
    }
}

