import torch
import torch.nn.functional as F
from torch_geometric.datasets import Planetoid
from torch_geometric.nn import GCNConv
import os
from gcn_model import GCN

# 加载 Cora 数据集
dataset = Planetoid(root='./data/Cora', name='Cora')

def test_model():
    device = torch.device('cuda' if torch.cuda.is_available() else 'cpu')
    model = GCN(dataset.num_node_features, dataset.num_classes).to(device)
    model.load_state_dict(torch.load('model.pt'))
    model.eval()

    data = dataset[0].to(device)
    with torch.no_grad():
        out = model(data)
        pred = out.argmax(dim=1)
        correct = (pred[data.test_mask] == data.y[data.test_mask]).sum()
        acc = int(correct) / int(data.test_mask.sum())
        print(f'Accuracy: {acc:.4f}')

if __name__ == "__main__":
    test_model()
