/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.utils;

import io.javalin.http.Context;
import java.net.InetAddress;
import java.util.HashMap;
import org.apache.amoro.exception.SignatureCheckException;
import org.apache.amoro.server.dashboard.utils.ParamSignatureCalculator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.telnet.TelnetClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CommonUtil.class);
    private static final String[] TOKEN_WHITE_LIST = new String[]{"/login/current", "/versionInfo"};

    public static boolean telnetOrPing(String addresses) {
        String[] split;
        for (String address : split = addresses.split(",")) {
            int port;
            String[] info = address.split(":");
            if (info.length < 2) {
                String[] ip = info[0].split("/");
                if (!CommonUtil.ping(ip[0])) continue;
                return true;
            }
            String[] portSplit = info[1].split("/");
            try {
                port = Integer.parseInt(portSplit[0]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(portSplit[0] + " is not port");
            }
            if (!CommonUtil.telnet(info[0], port)) continue;
            return true;
        }
        return false;
    }

    public static boolean telnet(String host, int port) {
        try {
            TelnetClient telnetClient = new TelnetClient("vt200");
            telnetClient.setConnectTimeout(500);
            telnetClient.connect(host, port);
            telnetClient.disconnect();
            return true;
        }
        catch (Exception e) {
            LOG.warn("telnet {} {} timeout! ", (Object)host, (Object)port);
            return false;
        }
    }

    public static boolean ping(String ip) {
        try {
            return InetAddress.getByName(ip).isReachable(500);
        }
        catch (Exception e) {
            LOG.warn("ping {} timeout! ", (Object)ip);
            return false;
        }
    }

    public static void checkSinglePageToken(Context ctx) {
        String token = ctx.queryParam("token");
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            String url = ctx.req.getRequestURI();
            for (String whiteListUrl : TOKEN_WHITE_LIST) {
                if (!url.contains(whiteListUrl)) continue;
                return;
            }
            String catalog = ctx.queryParam("catalog");
            String db = ctx.queryParam("db");
            String table = ctx.queryParam("table");
            if (StringUtils.isEmpty((CharSequence)catalog) && StringUtils.isEmpty((CharSequence)db) && StringUtils.isEmpty((CharSequence)table)) {
                String[] splitResult = url.split("/");
                block11: for (int i = 0; i < splitResult.length; ++i) {
                    switch (splitResult[i]) {
                        case "catalogs": {
                            catalog = splitResult[i + 1];
                            continue block11;
                        }
                        case "dbs": {
                            db = splitResult[i + 1];
                            continue block11;
                        }
                        case "tables": {
                            table = splitResult[i + 1];
                        }
                    }
                }
            }
            if (StringUtils.isEmpty((CharSequence)catalog) || StringUtils.isEmpty((CharSequence)db) || StringUtils.isEmpty((CharSequence)table) || !token.equals(CommonUtil.generateTablePageToken(catalog, db, table))) {
                throw new SignatureCheckException();
            }
        }
    }

    public static String generateTablePageToken(String catalog, String db, String table) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("catalog", catalog);
        params.put("db", db);
        params.put("table", table);
        String paramString = ParamSignatureCalculator.generateParamStringWithValue(params);
        String plainText = String.format("%s%s%s", paramString, paramString, paramString);
        return ParamSignatureCalculator.getMD5(plainText);
    }
}

