/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.dashboard.response;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class PageResult<R> {
    private static final PageResult<?> EMPTY = new PageResult(0);
    private List<R> list;
    private int total;

    private PageResult(List<R> list, int total) {
        this.list = list;
        this.total = total;
    }

    private PageResult(int total) {
        this.list = Collections.emptyList();
        this.total = total;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public static PageResult<?> empty() {
        return EMPTY;
    }

    public List<R> getList() {
        return this.list;
    }

    public void setList(List<R> list) {
        this.list = list;
    }

    public static <R> PageResult<R> of(List<R> list, int total) {
        return new PageResult<R>(list, total);
    }

    public static <R> PageResult<R> of(List<R> list, int offset, int limit) {
        if (CollectionUtils.isEmpty(list)) {
            return new PageResult(Collections.emptyList(), 0);
        }
        List result = list.stream().skip(offset).limit(limit).collect(Collectors.toList());
        return new PageResult(result, list.size());
    }

    public static <T, R> PageResult<R> of(List<T> list, int offset, int limit, Function<T, R> convert) {
        if (CollectionUtils.isEmpty(list)) {
            return new PageResult(Collections.emptyList(), 0);
        }
        List result = list.stream().skip(offset).limit(limit).map(convert).collect(Collectors.toList());
        return new PageResult(result, list.size());
    }
}

