/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.LongPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.LocalSnapshotDirectoryProvider;
import org.apache.flink.runtime.state.TaskLocalStateStoreImpl;
import org.apache.flink.runtime.state.changelog.ChangelogStateBackendHandle;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangelogTaskLocalStateStore
extends TaskLocalStateStoreImpl {
    private static final Logger LOG = LoggerFactory.getLogger(ChangelogTaskLocalStateStore.class);
    private static final String CHANGE_LOG_CHECKPOINT_PREFIX = "changelog_chk_";
    private final Map<Long, Long> mapToMaterializationId = new HashMap<Long, Long>();
    private long lastCheckpointId = -1L;

    public ChangelogTaskLocalStateStore(@Nonnull JobID jobID, @Nonnull AllocationID allocationID, @Nonnull JobVertexID jobVertexID, @Nonnegative int subtaskIndex, @Nonnull LocalRecoveryConfig localRecoveryConfig, @Nonnull Executor discardExecutor) {
        super(jobID, allocationID, jobVertexID, subtaskIndex, localRecoveryConfig, discardExecutor);
    }

    private void updateReference(long checkpointId, TaskStateSnapshot localState) {
        if (localState == null) {
            localState = NULL_DUMMY;
        }
        for (Map.Entry<OperatorID, OperatorSubtaskState> subtaskStateEntry : localState.getSubtaskStateMappings()) {
            for (KeyedStateHandle keyedStateHandle : subtaskStateEntry.getValue().getManagedKeyedState()) {
                if (!(keyedStateHandle instanceof ChangelogStateBackendHandle)) continue;
                ChangelogStateBackendHandle changelogStateBackendHandle = (ChangelogStateBackendHandle)keyedStateHandle;
                long materializationID = changelogStateBackendHandle.getMaterializationID();
                if (this.mapToMaterializationId.containsKey(checkpointId)) {
                    Preconditions.checkState((materializationID == this.mapToMaterializationId.get(checkpointId) ? 1 : 0) != 0, (Object)"one checkpoint contains at most one materializationID");
                    continue;
                }
                this.mapToMaterializationId.put(checkpointId, materializationID);
            }
        }
    }

    public static Path getLocalTaskOwnedDirectory(LocalSnapshotDirectoryProvider provider, JobID jobID) {
        File outDir = provider.selectAllocationBaseDirectory((jobID.hashCode() & Integer.MAX_VALUE) % provider.allocationBaseDirsCount());
        if (!outDir.exists() && !outDir.mkdirs()) {
            LOG.error("Local state base directory does not exist and could not be created: " + outDir);
        }
        return new Path(String.format("%s/jid_%s", outDir.toURI(), jobID), "taskowned");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeLocalState(long checkpointId, @Nullable TaskStateSnapshot localState) {
        if (checkpointId < this.lastCheckpointId) {
            LOG.info("Current checkpoint {} is out of order, smaller than last CheckpointId {}.", (Object)this.lastCheckpointId, (Object)checkpointId);
            return;
        }
        this.lastCheckpointId = checkpointId;
        Object object = this.lock;
        synchronized (object) {
            this.updateReference(checkpointId, localState);
        }
        super.storeLocalState(checkpointId, localState);
    }

    @Override
    protected File getCheckpointDirectory(long checkpointId) {
        return new File(this.getLocalRecoveryDirectoryProvider().subtaskBaseDirectory(checkpointId), CHANGE_LOG_CHECKPOINT_PREFIX + checkpointId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMaterialization(LongPredicate pruningChecker) {
        Set materializationToRemove;
        Object object = this.lock;
        synchronized (object) {
            Set checkpoints = this.mapToMaterializationId.keySet().stream().filter(pruningChecker::test).collect(Collectors.toSet());
            materializationToRemove = checkpoints.stream().map(this.mapToMaterializationId::remove).collect(Collectors.toSet());
            materializationToRemove.removeAll(this.mapToMaterializationId.values());
        }
        this.discardExecutor.execute(() -> this.syncDiscardFileForCollection(materializationToRemove.stream().map(x$0 -> super.getCheckpointDirectory((long)x$0)).collect(Collectors.toList())));
    }

    private void syncDiscardFileForCollection(Collection<File> toDiscard) {
        for (File directory : toDiscard) {
            if (!directory.exists()) continue;
            try {
                this.deleteDirectory(directory);
            }
            catch (IOException ex) {
                LOG.warn("Exception while deleting local state directory of {} in subtask ({} - {} - {}).", new Object[]{directory, this.jobID, this.jobVertexID, this.subtaskIndex, ex});
            }
        }
    }

    @Override
    public void pruneCheckpoints(LongPredicate pruningChecker, boolean breakOnceCheckerFalse) {
        super.pruneCheckpoints(pruningChecker, false);
        this.deleteMaterialization(pruningChecker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> dispose() {
        this.deleteMaterialization(id -> true);
        this.discardExecutor.execute(() -> this.syncDiscardFileForCollection(Collections.singleton(new File(ChangelogTaskLocalStateStore.getLocalTaskOwnedDirectory(this.getLocalRecoveryDirectoryProvider(), this.jobID).toUri()))));
        Object object = this.lock;
        synchronized (object) {
            this.mapToMaterializationId.clear();
        }
        return super.dispose();
    }

    @Override
    public String toString() {
        return "ChangelogTaskLocalStateStore{jobID=" + this.jobID + ", jobVertexID=" + this.jobVertexID + ", allocationID=" + this.allocationID.toHexString() + ", subtaskIndex=" + this.subtaskIndex + ", localRecoveryConfig=" + this.localRecoveryConfig + ", storedCheckpointIDs=" + this.storedTaskStateByCheckpointID.keySet() + ", mapToMaterializationId=" + this.mapToMaterializationId.entrySet() + '}';
    }
}

