/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.jobmaster.slotpool.AbstractServiceConnectionManager;
import org.apache.flink.runtime.jobmaster.slotpool.DeclareResourceRequirementServiceConnectionManager;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.slots.ResourceRequirements;
import org.apache.flink.util.concurrent.ExponentialBackoffRetryStrategy;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.concurrent.RetryStrategy;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultDeclareResourceRequirementServiceConnectionManager
extends AbstractServiceConnectionManager<DeclareResourceRequirementServiceConnectionManager.DeclareResourceRequirementsService>
implements DeclareResourceRequirementServiceConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDeclareResourceRequirementServiceConnectionManager.class);
    private final ScheduledExecutor scheduledExecutor;
    @Nullable
    @GuardedBy(value="lock")
    private ResourceRequirements currentResourceRequirements;

    private DefaultDeclareResourceRequirementServiceConnectionManager(ScheduledExecutor scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void declareResourceRequirements(ResourceRequirements resourceRequirements) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if (this.isConnected()) {
                this.currentResourceRequirements = resourceRequirements;
                this.triggerResourceRequirementsSubmission(Duration.ofMillis(1L), Duration.ofMillis(10000L), this.currentResourceRequirements);
            }
        }
    }

    @GuardedBy(value="lock")
    private void triggerResourceRequirementsSubmission(Duration sleepOnError, Duration maxSleepOnError, ResourceRequirements resourceRequirementsToSend) {
        FutureUtils.retryWithDelay(() -> this.sendResourceRequirements(resourceRequirementsToSend), (RetryStrategy)new ExponentialBackoffRetryStrategy(Integer.MAX_VALUE, sleepOnError, maxSleepOnError), throwable -> !(throwable instanceof CancellationException), (ScheduledExecutor)this.scheduledExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Acknowledge> sendResourceRequirements(ResourceRequirements resourceRequirementsToSend) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isConnected()) {
                if (resourceRequirementsToSend == this.currentResourceRequirements) {
                    return ((DeclareResourceRequirementServiceConnectionManager.DeclareResourceRequirementsService)this.service).declareResourceRequirements(resourceRequirementsToSend);
                }
                LOG.debug("Newer resource requirements found. Stop sending old requirements.");
                return FutureUtils.completedExceptionally((Throwable)new CancellationException());
            }
            LOG.debug("Stop sending resource requirements to ResourceManager because it is not connected.");
            return FutureUtils.completedExceptionally((Throwable)new CancellationException());
        }
    }

    public static DeclareResourceRequirementServiceConnectionManager create(ScheduledExecutor scheduledExecutor) {
        return new DefaultDeclareResourceRequirementServiceConnectionManager(scheduledExecutor);
    }
}

