/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.core5.http.io.EofSensorInputStream;
import org.apache.hc.core5.http.io.EofSensorWatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestEofSensorInputStream {
    private InputStream inStream;
    private EofSensorWatcher eofwatcher;
    private EofSensorInputStream eofstream;

    TestEofSensorInputStream() {
    }

    @BeforeEach
    void setup() {
        this.inStream = (InputStream)Mockito.mock(InputStream.class);
        this.eofwatcher = (EofSensorWatcher)Mockito.mock(EofSensorWatcher.class);
        this.eofstream = new EofSensorInputStream(this.inStream, this.eofwatcher);
    }

    @Test
    void testClose() throws Exception {
        Mockito.when((Object)this.eofwatcher.streamClosed((InputStream)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        this.eofstream.close();
        Assertions.assertTrue((boolean)this.eofstream.isSelfClosed());
        Assertions.assertNull((Object)this.eofstream.getWrappedStream());
        ((InputStream)Mockito.verify((Object)this.inStream, (VerificationMode)Mockito.times((int)1))).close();
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).streamClosed(this.inStream);
        this.eofstream.close();
    }

    @Test
    void testCloseIOError() throws Exception {
        Mockito.when((Object)this.eofwatcher.streamClosed((InputStream)Mockito.any())).thenThrow(new Throwable[]{new IOException()});
        Assertions.assertThrows(IOException.class, () -> this.eofstream.close());
        Assertions.assertTrue((boolean)this.eofstream.isSelfClosed());
        Assertions.assertNull((Object)this.eofstream.getWrappedStream());
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).streamClosed(this.inStream);
    }

    @Test
    void testAbortConnection() throws Exception {
        Mockito.when((Object)this.eofwatcher.streamAbort((InputStream)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        this.eofstream.abort();
        Assertions.assertTrue((boolean)this.eofstream.isSelfClosed());
        Assertions.assertNull((Object)this.eofstream.getWrappedStream());
        ((InputStream)Mockito.verify((Object)this.inStream, (VerificationMode)Mockito.times((int)1))).close();
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).streamAbort(this.inStream);
        this.eofstream.abort();
    }

    @Test
    void testAbortConnectionIOError() throws Exception {
        Mockito.when((Object)this.eofwatcher.streamAbort((InputStream)Mockito.any())).thenThrow(new Throwable[]{new IOException()});
        Assertions.assertThrows(IOException.class, () -> this.eofstream.abort());
        Assertions.assertTrue((boolean)this.eofstream.isSelfClosed());
        Assertions.assertNull((Object)this.eofstream.getWrappedStream());
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).streamAbort(this.inStream);
    }

    @Test
    void testRead() throws Exception {
        Mockito.when((Object)this.eofwatcher.eofDetected((InputStream)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.inStream.read()).thenReturn((Object)0, (Object[])new Integer[]{-1});
        Assertions.assertEquals((int)0, (int)this.eofstream.read());
        Assertions.assertFalse((boolean)this.eofstream.isSelfClosed());
        Assertions.assertNotNull((Object)this.eofstream.getWrappedStream());
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher, (VerificationMode)Mockito.never())).eofDetected(this.inStream);
        Assertions.assertEquals((int)-1, (int)this.eofstream.read());
        Assertions.assertFalse((boolean)this.eofstream.isSelfClosed());
        Assertions.assertNull((Object)this.eofstream.getWrappedStream());
        ((InputStream)Mockito.verify((Object)this.inStream, (VerificationMode)Mockito.times((int)1))).close();
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).eofDetected(this.inStream);
        Assertions.assertEquals((int)-1, (int)this.eofstream.read());
    }

    @Test
    void testReadIOError() throws Exception {
        Mockito.when((Object)this.eofwatcher.eofDetected((InputStream)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.inStream.read()).thenThrow(new Throwable[]{new IOException()});
        Assertions.assertThrows(IOException.class, () -> this.eofstream.read());
        Assertions.assertFalse((boolean)this.eofstream.isSelfClosed());
        Assertions.assertNull((Object)this.eofstream.getWrappedStream());
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).streamAbort(this.inStream);
    }

    @Test
    void testReadByteArray() throws Exception {
        Mockito.when((Object)this.eofwatcher.eofDetected((InputStream)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.inStream.read((byte[])Mockito.any(), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)1, (Object[])new Integer[]{-1});
        byte[] tmp = new byte[1];
        Assertions.assertEquals((int)1, (int)this.eofstream.read(tmp));
        Assertions.assertFalse((boolean)this.eofstream.isSelfClosed());
        Assertions.assertNotNull((Object)this.eofstream.getWrappedStream());
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher, (VerificationMode)Mockito.never())).eofDetected(this.inStream);
        Assertions.assertEquals((int)-1, (int)this.eofstream.read(tmp));
        Assertions.assertFalse((boolean)this.eofstream.isSelfClosed());
        Assertions.assertNull((Object)this.eofstream.getWrappedStream());
        ((InputStream)Mockito.verify((Object)this.inStream, (VerificationMode)Mockito.times((int)1))).close();
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).eofDetected(this.inStream);
        Assertions.assertEquals((int)-1, (int)this.eofstream.read(tmp));
    }

    @Test
    void testReadByteArrayIOError() throws Exception {
        Mockito.when((Object)this.eofwatcher.eofDetected((InputStream)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.inStream.read((byte[])Mockito.any(), Mockito.anyInt(), Mockito.anyInt())).thenThrow(new Throwable[]{new IOException()});
        byte[] tmp = new byte[1];
        Assertions.assertThrows(IOException.class, () -> this.eofstream.read(tmp));
        Assertions.assertFalse((boolean)this.eofstream.isSelfClosed());
        Assertions.assertNull((Object)this.eofstream.getWrappedStream());
        ((EofSensorWatcher)Mockito.verify((Object)this.eofwatcher)).streamAbort(this.inStream);
    }

    @Test
    void testReadAfterAbort() throws Exception {
        Mockito.when((Object)this.eofwatcher.streamAbort((InputStream)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        this.eofstream.abort();
        Assertions.assertThrows(IOException.class, () -> this.eofstream.read());
        byte[] tmp = new byte[1];
        Assertions.assertThrows(IOException.class, () -> this.eofstream.read(tmp));
    }
}

