/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.auth.jwt;

import com.google.common.base.Preconditions;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.JWKSourceBuilder;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import java.net.URL;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JWTValidator {
    private static final Set<JWSAlgorithm> ACCEPTABLE_ALGORITHMS = new HashSet<JWSAlgorithm>((Collection<JWSAlgorithm>)JWSAlgorithm.Family.SIGNATURE);
    private final ConfigurableJWTProcessor<SecurityContext> jwtProcessor = new DefaultJWTProcessor();

    public JWTValidator(Set<JOSEObjectType> acceptableTypes, List<URL> jwksURLs, String expectedIssuer, String expectedAudience, Set<String> requiredClaimNames) {
        this.jwtProcessor.setJWSTypeVerifier((JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier(acceptableTypes));
        Preconditions.checkArgument((!jwksURLs.isEmpty() ? 1 : 0) != 0);
        JWSVerificationKeySelector keySelector = new JWSVerificationKeySelector(ACCEPTABLE_ALGORITHMS, this.getKeySource(jwksURLs));
        this.jwtProcessor.setJWSKeySelector((JWSKeySelector)keySelector);
        JWTClaimsSet.Builder expectedClaimsBuilder = new JWTClaimsSet.Builder();
        if (expectedIssuer != null) {
            expectedClaimsBuilder.issuer(expectedIssuer);
        }
        this.jwtProcessor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier(expectedAudience, expectedClaimsBuilder.build(), requiredClaimNames));
    }

    private JWKSource<SecurityContext> getKeySource(List<URL> jwkURLs) {
        URL head = jwkURLs.getFirst();
        JWKSourceBuilder builder = JWKSourceBuilder.create((URL)head).retrying(true);
        List<URL> tail = jwkURLs.subList(1, jwkURLs.size());
        return tail.isEmpty() ? builder.build() : builder.failover(this.getKeySource(tail)).build();
    }

    public JWTClaimsSet validateJWT(String signedJwt) throws BadJOSEException, ParseException, JOSEException {
        Preconditions.checkNotNull((Object)signedJwt, (Object)"No token found");
        return this.jwtProcessor.process(signedJwt, null);
    }
}

