/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.FloatFloatHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class FloatFloatScatterMap
extends FloatFloatHashMap {
    public FloatFloatScatterMap() {
        this(4);
    }

    public FloatFloatScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public FloatFloatScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(float key) {
        return BitMixer.mixPhi(key);
    }

    public static FloatFloatScatterMap from(float[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        FloatFloatScatterMap map = new FloatFloatScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

