/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.privilege;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationTranslator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizationTranslator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveV1Authorizer;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class PrivilegeUtils {
    private static final HiveAuthorizationTranslator DEFAULT_AUTHORIZATION_TRANSLATOR = new DefaultHiveAuthorizationTranslator();

    private PrivilegeUtils() {
        throw new UnsupportedOperationException("PrivilegeUtils should not be instantiated");
    }

    public static HiveAuthorizer getSessionAuthorizer(HiveConf conf) {
        HiveAuthorizer authorizer = SessionState.get().getAuthorizerV2();
        if (authorizer == null) {
            authorizer = new HiveV1Authorizer(conf);
        }
        return authorizer;
    }

    public static void writeListToFileAfterSort(List<String> entries, String resFile, DDLOperationContext context) throws IOException {
        Collections.sort(entries);
        StringBuilder sb = new StringBuilder();
        for (String entry : entries) {
            ShowUtils.appendNonNull(sb, entry, true);
        }
        ShowUtils.writeToFile(sb.toString(), resFile, context);
    }

    public static HiveAuthorizationTranslator getAuthorizationTranslator(HiveAuthorizer authorizer) throws HiveAuthzPluginException {
        if (authorizer.getHiveAuthorizationTranslator() == null) {
            return DEFAULT_AUTHORIZATION_TRANSLATOR;
        }
        return (HiveAuthorizationTranslator)authorizer.getHiveAuthorizationTranslator();
    }
}

