/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.catalina.manager.Constants;
import org.apache.tomcat.util.json.JSONFilter;
import org.apache.tomcat.util.security.Escape;

public class StatusTransformer {
    public static void setContentType(HttpServletResponse response, int mode) {
        if (mode == 0) {
            response.setContentType("text/html;charset=utf-8");
        } else if (mode == 1) {
            response.setContentType("text/xml;charset=utf-8");
        } else if (mode == 2) {
            response.setContentType("application/json;charset=utf-8");
        }
    }

    public static void writeHeader(PrintWriter writer, Object[] args, int mode) {
        if (mode == 0) {
            writer.print(MessageFormat.format(Constants.HTML_HEADER_SECTION, args));
        } else if (mode == 1) {
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            writer.print(MessageFormat.format("<?xml-stylesheet type=\"text/xsl\" href=\"{0}/xform.xsl\" ?>\n", args));
            writer.write("<status>");
        } else if (mode == 2) {
            writer.append('{').append('\"').append("tomcat").append('\"').append(':').append('{').println();
        }
    }

    public static void writeBody(PrintWriter writer, Object[] args, int mode) {
        if (mode == 0) {
            writer.print(MessageFormat.format(Constants.BODY_HEADER_SECTION, args));
        }
    }

    public static void writeManager(PrintWriter writer, Object[] args, int mode) {
        if (mode == 0) {
            writer.print(MessageFormat.format(Constants.MANAGER_SECTION, args));
        }
    }

    public static void writePageHeading(PrintWriter writer, Object[] args, int mode) {
        if (mode == 0) {
            writer.print(MessageFormat.format(Constants.SERVER_HEADER_SECTION, args));
        }
    }

    public static void writeServerInfo(PrintWriter writer, Object[] args, int mode) {
        if (mode == 0) {
            writer.print(MessageFormat.format(Constants.SERVER_ROW_SECTION, args));
        }
    }

    public static void writeFooter(PrintWriter writer, int mode) {
        if (mode == 0) {
            writer.print(Constants.HTML_TAIL_SECTION);
        } else if (mode == 1) {
            writer.write("</status>");
        } else if (mode == 2) {
            writer.append('}').append('}');
        }
    }

    public static void writeVMState(PrintWriter writer, int mode, Object[] args) throws Exception {
        MemoryUsage usage;
        TreeMap<CallSite, MemoryPoolMXBean> memoryPoolMBeans = new TreeMap<CallSite, MemoryPoolMXBean>();
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            String sortKey = String.valueOf((Object)mbean.getType()) + ":" + mbean.getName();
            memoryPoolMBeans.put((CallSite)((Object)sortKey), mbean);
        }
        if (mode == 0) {
            writer.print("<h1>JVM</h1>");
            writer.print("<p>");
            writer.print(args[0]);
            writer.print(' ');
            writer.print(StatusTransformer.formatSize(Runtime.getRuntime().freeMemory(), true));
            writer.print(' ');
            writer.print(args[1]);
            writer.print(' ');
            writer.print(StatusTransformer.formatSize(Runtime.getRuntime().totalMemory(), true));
            writer.print(' ');
            writer.print(args[2]);
            writer.print(' ');
            writer.print(StatusTransformer.formatSize(Runtime.getRuntime().maxMemory(), true));
            writer.print("</p>");
            writer.write("<table border=\"0\"><thead><tr><th>" + String.valueOf(args[3]) + "</th><th>" + String.valueOf(args[4]) + "</th><th>" + String.valueOf(args[5]) + "</th><th>" + String.valueOf(args[6]) + "</th><th>" + String.valueOf(args[7]) + "</th><th>" + String.valueOf(args[8]) + "</th></tr></thead><tbody>");
            for (MemoryPoolMXBean memoryPoolMBean : memoryPoolMBeans.values()) {
                usage = memoryPoolMBean.getUsage();
                writer.write("<tr><td>");
                writer.print(memoryPoolMBean.getName());
                writer.write("</td><td>");
                writer.print((Object)memoryPoolMBean.getType());
                writer.write("</td><td>");
                writer.print(StatusTransformer.formatSize(usage.getInit(), true));
                writer.write("</td><td>");
                writer.print(StatusTransformer.formatSize(usage.getCommitted(), true));
                writer.write("</td><td>");
                writer.print(StatusTransformer.formatSize(usage.getMax(), true));
                writer.write("</td><td>");
                writer.print(StatusTransformer.formatSize(usage.getUsed(), true));
                if (usage.getMax() > 0L) {
                    writer.write(" (" + usage.getUsed() * 100L / usage.getMax() + "%)");
                }
                writer.write("</td></tr>");
            }
            writer.write("</tbody></table>");
        } else if (mode == 1) {
            writer.write("<jvm>");
            writer.write("<memory");
            writer.write(" free='" + Runtime.getRuntime().freeMemory() + "'");
            writer.write(" total='" + Runtime.getRuntime().totalMemory() + "'");
            writer.write(" max='" + Runtime.getRuntime().maxMemory() + "'/>");
            for (MemoryPoolMXBean memoryPoolMBean : memoryPoolMBeans.values()) {
                usage = memoryPoolMBean.getUsage();
                writer.write("<memorypool");
                writer.write(" name='" + Escape.xml("", memoryPoolMBean.getName()) + "'");
                writer.write(" type='" + String.valueOf((Object)memoryPoolMBean.getType()) + "'");
                writer.write(" usageInit='" + usage.getInit() + "'");
                writer.write(" usageCommitted='" + usage.getCommitted() + "'");
                writer.write(" usageMax='" + usage.getMax() + "'");
                writer.write(" usageUsed='" + usage.getUsed() + "'/>");
            }
            writer.write("</jvm>");
        } else if (mode == 2) {
            StatusTransformer.indent(writer, 1).append('\"').append("jvm").append('\"').append(':').append('{').println();
            StatusTransformer.indent(writer, 2).append('\"').append("memory").append('\"').append(':').append('{');
            StatusTransformer.appendJSonValue(writer, "free", Runtime.getRuntime().freeMemory()).append(',');
            StatusTransformer.appendJSonValue(writer, "total", Runtime.getRuntime().totalMemory()).append(',');
            StatusTransformer.appendJSonValue(writer, "max", Runtime.getRuntime().maxMemory());
            writer.append('}').append(',').println();
            StatusTransformer.indent(writer, 2).append('\"').append("memorypool").append('\"').append(':').append('[');
            boolean first = true;
            for (MemoryPoolMXBean memoryPoolMBean : memoryPoolMBeans.values()) {
                MemoryUsage usage2 = memoryPoolMBean.getUsage();
                if (first) {
                    first = false;
                    writer.println();
                } else {
                    writer.append(',').println();
                }
                StatusTransformer.indent(writer, 3).append('{');
                StatusTransformer.appendJSonValue(writer, "name", JSONFilter.escape(memoryPoolMBean.getName())).append(',');
                StatusTransformer.appendJSonValue(writer, "type", memoryPoolMBean.getType().toString()).append(',');
                StatusTransformer.appendJSonValue(writer, "usageInit", usage2.getInit()).append(',');
                StatusTransformer.appendJSonValue(writer, "usageCommitted", usage2.getCommitted()).append(',');
                StatusTransformer.appendJSonValue(writer, "usageMax", usage2.getMax()).append(',');
                StatusTransformer.appendJSonValue(writer, "usageUsed", usage2.getUsed());
                writer.append('}');
            }
            writer.println();
            StatusTransformer.indent(writer, 2).append(']').println();
            StatusTransformer.indent(writer, 1).append('}');
        }
    }

    private static PrintWriter appendJSonValue(PrintWriter writer, String name, Object value) {
        writer.append('\"').append(name).append('\"').append(':');
        if (value instanceof Number) {
            return writer.append(value.toString());
        }
        return writer.append('\"').append(value.toString()).append('\"');
    }

    private static PrintWriter indent(PrintWriter writer, int count) {
        for (int i = 0; i < count; ++i) {
            writer.append(' ').append(' ');
        }
        return writer;
    }

    public static void writeConnectorsState(PrintWriter writer, MBeanServer mBeanServer, List<ObjectName> threadPools, List<ObjectName> globalRequestProcessors, List<ObjectName> requestProcessors, int mode, Object[] args) throws Exception {
        if (mode == 2) {
            writer.append(',').println();
            StatusTransformer.indent(writer, 1).append('\"').append("connector").append('\"').append(':').append('[').println();
        }
        boolean first = true;
        for (ObjectName objectName : threadPools) {
            if (first) {
                first = false;
            } else if (mode == 2) {
                writer.append(',').println();
            }
            String name = objectName.getKeyProperty("name");
            StatusTransformer.writeConnectorState(writer, objectName, name, mBeanServer, globalRequestProcessors, requestProcessors, mode, args);
        }
        if (mode == 2) {
            writer.append(']');
        }
    }

    public static void writeConnectorState(PrintWriter writer, ObjectName tpName, String name, MBeanServer mBeanServer, List<ObjectName> globalRequestProcessors, List<ObjectName> requestProcessors, int mode, Object[] args) throws Exception {
        if (mode == 0) {
            writer.print("<h1>");
            writer.print(name);
            writer.print("</h1>");
            writer.print("<p>");
            writer.print(args[0]);
            writer.print(' ');
            writer.print(mBeanServer.getAttribute(tpName, "maxThreads"));
            writer.print(' ');
            writer.print(args[1]);
            writer.print(' ');
            writer.print(mBeanServer.getAttribute(tpName, "currentThreadCount"));
            writer.print(' ');
            writer.print(args[2]);
            writer.print(' ');
            writer.print(mBeanServer.getAttribute(tpName, "currentThreadsBusy"));
            writer.print(' ');
            writer.print(args[3]);
            writer.print(' ');
            writer.print(mBeanServer.getAttribute(tpName, "keepAliveCount"));
            writer.print("<br>");
            ObjectName grpName = null;
            for (ObjectName objectName : globalRequestProcessors) {
                if (!name.equals(objectName.getKeyProperty("name")) || objectName.getKeyProperty("Upgrade") != null) continue;
                grpName = objectName;
            }
            if (grpName == null) {
                return;
            }
            writer.print(args[4]);
            writer.print(' ');
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(grpName, "maxTime"), false));
            writer.print(' ');
            writer.print(args[5]);
            writer.print(' ');
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(grpName, "processingTime"), true));
            writer.print(' ');
            writer.print(args[6]);
            writer.print(' ');
            writer.print(mBeanServer.getAttribute(grpName, "requestCount"));
            writer.print(' ');
            writer.print(args[7]);
            writer.print(' ');
            writer.print(mBeanServer.getAttribute(grpName, "errorCount"));
            writer.print(' ');
            writer.print(args[8]);
            writer.print(' ');
            writer.print(StatusTransformer.formatSize(mBeanServer.getAttribute(grpName, "bytesReceived"), true));
            writer.print(' ');
            writer.print(args[9]);
            writer.print(' ');
            writer.print(StatusTransformer.formatSize(mBeanServer.getAttribute(grpName, "bytesSent"), true));
            writer.print("</p>");
            writer.print("<table border=\"0\"><tr><th>" + String.valueOf(args[10]) + "</th><th>" + String.valueOf(args[11]) + "</th><th>" + String.valueOf(args[12]) + "</th><th>" + String.valueOf(args[13]) + "</th><th>" + String.valueOf(args[14]) + "</th><th>" + String.valueOf(args[15]) + "</th><th>" + String.valueOf(args[16]) + "</th><th>" + String.valueOf(args[17]) + "</th></tr>");
            for (ObjectName objectName : requestProcessors) {
                if (!name.equals(StatusTransformer.getConnectorName(objectName.getKeyProperty("worker")))) continue;
                writer.print("<tr>");
                StatusTransformer.writeProcessorState(writer, objectName, mBeanServer, mode);
                writer.print("</tr>");
            }
            writer.print("</table>");
            writer.print("<p>");
            writer.print(args[18]);
            writer.print("</p>");
        } else if (mode == 1) {
            writer.write("<connector name='" + name + "'>");
            writer.write("<threadInfo ");
            writer.write(" maxThreads=\"" + String.valueOf(mBeanServer.getAttribute(tpName, "maxThreads")) + "\"");
            writer.write(" currentThreadCount=\"" + String.valueOf(mBeanServer.getAttribute(tpName, "currentThreadCount")) + "\"");
            writer.write(" currentThreadsBusy=\"" + String.valueOf(mBeanServer.getAttribute(tpName, "currentThreadsBusy")) + "\"");
            writer.write(" />");
            ObjectName grpName = null;
            for (ObjectName objectName : globalRequestProcessors) {
                if (!name.equals(objectName.getKeyProperty("name")) || objectName.getKeyProperty("Upgrade") != null) continue;
                grpName = objectName;
            }
            if (grpName != null) {
                writer.write("<requestInfo ");
                writer.write(" maxTime=\"" + String.valueOf(mBeanServer.getAttribute(grpName, "maxTime")) + "\"");
                writer.write(" processingTime=\"" + String.valueOf(mBeanServer.getAttribute(grpName, "processingTime")) + "\"");
                writer.write(" requestCount=\"" + String.valueOf(mBeanServer.getAttribute(grpName, "requestCount")) + "\"");
                writer.write(" errorCount=\"" + String.valueOf(mBeanServer.getAttribute(grpName, "errorCount")) + "\"");
                writer.write(" bytesReceived=\"" + String.valueOf(mBeanServer.getAttribute(grpName, "bytesReceived")) + "\"");
                writer.write(" bytesSent=\"" + String.valueOf(mBeanServer.getAttribute(grpName, "bytesSent")) + "\"");
                writer.write(" />");
                writer.write("<workers>");
                for (ObjectName objectName : requestProcessors) {
                    if (!name.equals(StatusTransformer.getConnectorName(objectName.getKeyProperty("worker")))) continue;
                    StatusTransformer.writeProcessorState(writer, objectName, mBeanServer, mode);
                }
                writer.write("</workers>");
            }
            writer.write("</connector>");
        } else if (mode == 2) {
            StatusTransformer.indent(writer, 2).append('{').println();
            StatusTransformer.indent(writer, 3);
            String jsonName = JSONFilter.escape(name);
            if (jsonName.length() > 4 && jsonName.startsWith("\\\"") && jsonName.endsWith("\\\"")) {
                jsonName = jsonName.substring(2, jsonName.length() - 2);
            }
            StatusTransformer.appendJSonValue(writer, "name", jsonName).append(',').println();
            StatusTransformer.indent(writer, 3).append('\"').append("threadInfo").append('\"').append(':').append('{');
            StatusTransformer.appendJSonValue(writer, "maxThreads", mBeanServer.getAttribute(tpName, "maxThreads")).append(',');
            StatusTransformer.appendJSonValue(writer, "currentThreadCount", mBeanServer.getAttribute(tpName, "currentThreadCount")).append(',');
            StatusTransformer.appendJSonValue(writer, "currentThreadsBusy", mBeanServer.getAttribute(tpName, "currentThreadsBusy"));
            writer.append('}');
            ObjectName grpName = null;
            for (ObjectName objectName : globalRequestProcessors) {
                if (!name.equals(objectName.getKeyProperty("name")) || objectName.getKeyProperty("Upgrade") != null) continue;
                grpName = objectName;
            }
            if (grpName != null) {
                writer.append(',').println();
                StatusTransformer.indent(writer, 3).append('\"').append("requestInfo").append('\"').append(':').append('{');
                StatusTransformer.appendJSonValue(writer, "maxTime", mBeanServer.getAttribute(grpName, "maxTime")).append(',');
                StatusTransformer.appendJSonValue(writer, "processingTime", mBeanServer.getAttribute(grpName, "processingTime")).append(',');
                StatusTransformer.appendJSonValue(writer, "requestCount", mBeanServer.getAttribute(grpName, "requestCount")).append(',');
                StatusTransformer.appendJSonValue(writer, "errorCount", mBeanServer.getAttribute(grpName, "errorCount")).append(',');
                StatusTransformer.appendJSonValue(writer, "bytesReceived", mBeanServer.getAttribute(grpName, "bytesReceived")).append(',');
                StatusTransformer.appendJSonValue(writer, "bytesSent", mBeanServer.getAttribute(grpName, "bytesSent"));
                writer.append('}').println();
            }
            StatusTransformer.indent(writer, 2).append('}');
        }
    }

    protected static String getConnectorName(String name) {
        if (name.indexOf("-auto-") > 0) {
            return name.substring(0, name.lastIndexOf("-")) + "\"";
        }
        return name;
    }

    protected static void writeProcessorState(PrintWriter writer, ObjectName pName, MBeanServer mBeanServer, int mode) throws Exception {
        Integer stageValue = (Integer)mBeanServer.getAttribute(pName, "stage");
        int stage = stageValue;
        boolean fullStatus = true;
        boolean showRequest = true;
        String stageStr = null;
        switch (stage) {
            case 1: {
                stageStr = "P";
                fullStatus = false;
                break;
            }
            case 2: {
                stageStr = "P";
                fullStatus = false;
                break;
            }
            case 3: {
                stageStr = "S";
                break;
            }
            case 4: {
                stageStr = "F";
                break;
            }
            case 5: {
                stageStr = "F";
                break;
            }
            case 7: {
                stageStr = "R";
                fullStatus = false;
                break;
            }
            case 6: {
                stageStr = "K";
                showRequest = false;
                break;
            }
            case 0: {
                stageStr = "R";
                fullStatus = false;
                break;
            }
            default: {
                stageStr = "?";
                fullStatus = false;
            }
        }
        if (mode == 0) {
            writer.write("<td><strong>");
            writer.write(stageStr);
            writer.write("</strong></td>");
            if (fullStatus) {
                writer.write("<td>");
                writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(pName, "requestProcessingTime"), false));
                writer.write("</td>");
                writer.write("<td>");
                if (showRequest) {
                    writer.print(StatusTransformer.formatSize(mBeanServer.getAttribute(pName, "requestBytesSent"), false));
                } else {
                    writer.write("?");
                }
                writer.write("</td>");
                writer.write("<td>");
                if (showRequest) {
                    writer.print(StatusTransformer.formatSize(mBeanServer.getAttribute(pName, "requestBytesReceived"), false));
                } else {
                    writer.write("?");
                }
                writer.write("</td>");
                writer.write("<td>");
                writer.print(Escape.htmlElementContent(mBeanServer.getAttribute(pName, "remoteAddrForwarded")));
                writer.write("</td>");
                writer.write("<td>");
                writer.print(Escape.htmlElementContent(mBeanServer.getAttribute(pName, "remoteAddr")));
                writer.write("</td>");
                writer.write("<td nowrap>");
                writer.write(Escape.htmlElementContent(mBeanServer.getAttribute(pName, "virtualHost")));
                writer.write("</td>");
                writer.write("<td nowrap class=\"row-left\">");
                if (showRequest) {
                    writer.write(Escape.htmlElementContent(mBeanServer.getAttribute(pName, "method")));
                    writer.write(32);
                    writer.write(Escape.htmlElementContent(mBeanServer.getAttribute(pName, "currentUri")));
                    String queryString = (String)mBeanServer.getAttribute(pName, "currentQueryString");
                    if (queryString != null && !queryString.equals("")) {
                        writer.write("?");
                        writer.print(Escape.htmlElementContent(queryString));
                    }
                    writer.write(32);
                    writer.write(Escape.htmlElementContent(mBeanServer.getAttribute(pName, "protocol")));
                } else {
                    writer.write("?");
                }
                writer.write("</td>");
            } else {
                writer.write("<td>?</td><td>?</td><td>?</td><td>?</td><td>?</td><td>?</td>");
            }
        } else if (mode == 1) {
            writer.write("<worker ");
            writer.write(" stage=\"" + stageStr + "\"");
            if (fullStatus) {
                writer.write(" requestProcessingTime=\"" + String.valueOf(mBeanServer.getAttribute(pName, "requestProcessingTime")) + "\"");
                writer.write(" requestBytesSent=\"");
                if (showRequest) {
                    writer.write(String.valueOf(mBeanServer.getAttribute(pName, "requestBytesSent")));
                } else {
                    writer.write("0");
                }
                writer.write("\"");
                writer.write(" requestBytesReceived=\"");
                if (showRequest) {
                    writer.write(String.valueOf(mBeanServer.getAttribute(pName, "requestBytesReceived")));
                } else {
                    writer.write("0");
                }
                writer.write("\"");
                writer.write(" remoteAddr=\"" + Escape.htmlElementContent(mBeanServer.getAttribute(pName, "remoteAddr")) + "\"");
                writer.write(" virtualHost=\"" + Escape.htmlElementContent(mBeanServer.getAttribute(pName, "virtualHost")) + "\"");
                if (showRequest) {
                    writer.write(" method=\"" + Escape.htmlElementContent(mBeanServer.getAttribute(pName, "method")) + "\"");
                    writer.write(" currentUri=\"" + Escape.htmlElementContent(mBeanServer.getAttribute(pName, "currentUri")) + "\"");
                    String queryString = (String)mBeanServer.getAttribute(pName, "currentQueryString");
                    if (queryString != null && !queryString.equals("")) {
                        writer.write(" currentQueryString=\"" + Escape.htmlElementContent(queryString) + "\"");
                    } else {
                        writer.write(" currentQueryString=\"&#63;\"");
                    }
                    writer.write(" protocol=\"" + Escape.htmlElementContent(mBeanServer.getAttribute(pName, "protocol")) + "\"");
                } else {
                    writer.write(" method=\"&#63;\"");
                    writer.write(" currentUri=\"&#63;\"");
                    writer.write(" currentQueryString=\"&#63;\"");
                    writer.write(" protocol=\"&#63;\"");
                }
            } else {
                writer.write(" requestProcessingTime=\"0\"");
                writer.write(" requestBytesSent=\"0\"");
                writer.write(" requestBytesReceived=\"0\"");
                writer.write(" remoteAddr=\"&#63;\"");
                writer.write(" virtualHost=\"&#63;\"");
                writer.write(" method=\"&#63;\"");
                writer.write(" currentUri=\"&#63;\"");
                writer.write(" currentQueryString=\"&#63;\"");
                writer.write(" protocol=\"&#63;\"");
            }
            writer.write(" />");
        }
    }

    public static void writeDetailedState(PrintWriter writer, MBeanServer mBeanServer, int mode) throws Exception {
        ObjectName queryHosts = new ObjectName("*:j2eeType=WebModule,*");
        Set<ObjectName> hostsON = mBeanServer.queryNames(queryHosts, null);
        if (mode == 0) {
            writer.print("<h1>");
            writer.print("Application list");
            writer.print("</h1>");
            writer.print("<p>");
            int count = 0;
            Iterator<ObjectName> iterator = hostsON.iterator();
            while (iterator.hasNext()) {
                int slash;
                ObjectName contextON = iterator.next();
                String webModuleName = contextON.getKeyProperty("name");
                if (webModuleName.startsWith("//")) {
                    webModuleName = webModuleName.substring(2);
                }
                if ((slash = webModuleName.indexOf(47)) == -1) {
                    ++count;
                    continue;
                }
                writer.print("<a href=\"#" + count++ + ".0\">");
                writer.print(Escape.htmlElementContent(webModuleName));
                writer.print("</a>");
                if (!iterator.hasNext()) continue;
                writer.print("<br>");
            }
            writer.print("</p>");
            count = 0;
            for (ObjectName contextON : hostsON) {
                writer.print("<a class=\"A.name\" name=\"" + count++ + ".0\">");
                StatusTransformer.writeContext(writer, contextON, mBeanServer, mode);
            }
        } else if (mode != 1 && mode == 2) {
            writer.append(',').println();
            StatusTransformer.indent(writer, 1).append('\"').append("context").append('\"').append(':').append('[').println();
            Iterator<ObjectName> iterator = hostsON.iterator();
            boolean first = true;
            while (iterator.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    writer.append(',').println();
                }
                ObjectName contextON = iterator.next();
                StatusTransformer.writeContext(writer, contextON, mBeanServer, mode);
            }
            writer.println();
            StatusTransformer.indent(writer, 1).append(']').println();
        }
    }

    protected static void writeContext(PrintWriter writer, ObjectName objectName, MBeanServer mBeanServer, int mode) throws Exception {
        int slash;
        String webModuleName = objectName.getKeyProperty("name");
        String name = webModuleName;
        if (name == null) {
            return;
        }
        String hostName = null;
        String contextName = null;
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        if ((slash = name.indexOf(47)) == -1) {
            return;
        }
        hostName = name.substring(0, slash);
        contextName = name.substring(slash);
        ObjectName queryManager = new ObjectName(objectName.getDomain() + ":type=Manager,context=" + contextName + ",host=" + hostName + ",*");
        Set<ObjectName> managersON = mBeanServer.queryNames(queryManager, null);
        ObjectName managerON = null;
        Iterator<ObjectName> iterator = managersON.iterator();
        while (iterator.hasNext()) {
            ObjectName aManagersON;
            managerON = aManagersON = iterator.next();
        }
        ObjectName queryJspMonitor = new ObjectName(objectName.getDomain() + ":type=JspMonitor,WebModule=" + webModuleName + ",*");
        Set<ObjectName> jspMonitorONs = mBeanServer.queryNames(queryJspMonitor, null);
        if (contextName.equals("/")) {
            contextName = "";
        }
        if (mode == 0) {
            writer.print("<h1>");
            writer.print(Escape.htmlElementContent(name));
            writer.print("</h1>");
            writer.print("</a>");
            writer.print("<p>");
            Object startTime = mBeanServer.getAttribute(objectName, "startTime");
            writer.print(" Start time: " + String.valueOf(new Date((Long)startTime)));
            writer.print(" Startup time: ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "startupTime"), false));
            writer.print(" TLD scan time: ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "tldScanTime"), false));
            if (managerON != null) {
                StatusTransformer.writeManager(writer, managerON, mBeanServer, mode);
            }
            if (jspMonitorONs != null) {
                StatusTransformer.writeJspMonitor(writer, jspMonitorONs, mBeanServer, mode);
            }
            writer.print("</p>");
            String onStr = objectName.getDomain() + ":j2eeType=Servlet,WebModule=" + webModuleName + ",*";
            ObjectName servletObjectName = new ObjectName(onStr);
            Set<ObjectInstance> set = mBeanServer.queryMBeans(servletObjectName, null);
            for (ObjectInstance oi : set) {
                StatusTransformer.writeWrapper(writer, oi.getObjectName(), mBeanServer, mode);
            }
        } else if (mode != 1 && mode == 2) {
            StatusTransformer.indent(writer, 2).append('{').println();
            StatusTransformer.appendJSonValue(StatusTransformer.indent(writer, 3), "name", JSONFilter.escape(JSONFilter.escape(name))).append(',');
            StatusTransformer.appendJSonValue(writer, "startTime", new Date((Long)mBeanServer.getAttribute(objectName, "startTime")).toString()).append(',');
            StatusTransformer.appendJSonValue(writer, "startupTime", mBeanServer.getAttribute(objectName, "startupTime")).append(',');
            StatusTransformer.appendJSonValue(writer, "tldScanTime", mBeanServer.getAttribute(objectName, "tldScanTime"));
            if (managerON != null) {
                StatusTransformer.writeManager(writer, managerON, mBeanServer, mode);
            }
            if (jspMonitorONs != null) {
                StatusTransformer.writeJspMonitor(writer, jspMonitorONs, mBeanServer, mode);
            }
            writer.append(',').println();
            StatusTransformer.indent(writer, 3).append('\"').append("wrapper").append('\"').append(':').append('[').println();
            String onStr = objectName.getDomain() + ":j2eeType=Servlet,WebModule=" + webModuleName + ",*";
            ObjectName servletObjectName = new ObjectName(onStr);
            Set<ObjectInstance> set = mBeanServer.queryMBeans(servletObjectName, null);
            boolean first = true;
            for (ObjectInstance oi : set) {
                if (first) {
                    first = false;
                } else {
                    writer.append(',').println();
                }
                StatusTransformer.writeWrapper(writer, oi.getObjectName(), mBeanServer, mode);
            }
            writer.println();
            StatusTransformer.indent(writer, 3).append(']').println();
            StatusTransformer.indent(writer, 2).append('}');
        }
    }

    public static void writeManager(PrintWriter writer, ObjectName objectName, MBeanServer mBeanServer, int mode) throws Exception {
        if (mode == 0) {
            writer.print("<br>");
            writer.print(" Active sessions: ");
            writer.print(mBeanServer.getAttribute(objectName, "activeSessions"));
            writer.print(" Session count: ");
            writer.print(mBeanServer.getAttribute(objectName, "sessionCounter"));
            writer.print(" Max active sessions: ");
            writer.print(mBeanServer.getAttribute(objectName, "maxActive"));
            writer.print(" Rejected session creations: ");
            writer.print(mBeanServer.getAttribute(objectName, "rejectedSessions"));
            writer.print(" Expired sessions: ");
            writer.print(mBeanServer.getAttribute(objectName, "expiredSessions"));
            writer.print(" Longest session alive time: ");
            writer.print(StatusTransformer.formatSeconds(mBeanServer.getAttribute(objectName, "sessionMaxAliveTime")));
            writer.print(" Average session alive time: ");
            writer.print(StatusTransformer.formatSeconds(mBeanServer.getAttribute(objectName, "sessionAverageAliveTime")));
            writer.print(" Processing time: ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "processingTime"), false));
        } else if (mode != 1 && mode == 2) {
            writer.append(',').println();
            StatusTransformer.indent(writer, 3).append('\"').append("manager").append('\"').append(':').append('{');
            StatusTransformer.appendJSonValue(writer, "activeSessions", mBeanServer.getAttribute(objectName, "activeSessions")).append(',');
            StatusTransformer.appendJSonValue(writer, "sessionCounter", mBeanServer.getAttribute(objectName, "sessionCounter")).append(',');
            StatusTransformer.appendJSonValue(writer, "maxActive", mBeanServer.getAttribute(objectName, "maxActive")).append(',');
            StatusTransformer.appendJSonValue(writer, "rejectedSessions", mBeanServer.getAttribute(objectName, "rejectedSessions")).append(',');
            StatusTransformer.appendJSonValue(writer, "expiredSessions", mBeanServer.getAttribute(objectName, "expiredSessions")).append(',');
            StatusTransformer.appendJSonValue(writer, "sessionMaxAliveTime", mBeanServer.getAttribute(objectName, "sessionMaxAliveTime")).append(',');
            StatusTransformer.appendJSonValue(writer, "sessionAverageAliveTime", mBeanServer.getAttribute(objectName, "sessionAverageAliveTime")).append(',');
            StatusTransformer.appendJSonValue(writer, "processingTime", mBeanServer.getAttribute(objectName, "processingTime"));
            writer.append('}');
        }
    }

    public static void writeJspMonitor(PrintWriter writer, Set<ObjectName> jspMonitorONs, MBeanServer mBeanServer, int mode) throws Exception {
        int jspCount = 0;
        int jspReloadCount = 0;
        for (ObjectName jspMonitorON : jspMonitorONs) {
            Object obj = mBeanServer.getAttribute(jspMonitorON, "jspCount");
            jspCount += ((Integer)obj).intValue();
            obj = mBeanServer.getAttribute(jspMonitorON, "jspReloadCount");
            jspReloadCount += ((Integer)obj).intValue();
        }
        if (mode == 0) {
            writer.print("<br>");
            writer.print(" JSPs loaded: ");
            writer.print(jspCount);
            writer.print(" JSPs reloaded: ");
            writer.print(jspReloadCount);
        } else if (mode != 1 && mode == 2) {
            writer.append(',').println();
            StatusTransformer.indent(writer, 3).append('\"').append("jsp").append('\"').append(':').append('{');
            StatusTransformer.appendJSonValue(writer, "jspCount", jspCount).append(',');
            StatusTransformer.appendJSonValue(writer, "jspReloadCount", jspReloadCount);
            writer.append('}');
        }
    }

    public static void writeWrapper(PrintWriter writer, ObjectName objectName, MBeanServer mBeanServer, int mode) throws Exception {
        String servletName = objectName.getKeyProperty("name");
        String[] mappings = (String[])mBeanServer.invoke(objectName, "findMappings", null, null);
        if (mode == 0) {
            writer.print("<h2>");
            writer.print(Escape.htmlElementContent(servletName));
            if (mappings != null && mappings.length > 0) {
                writer.print(" [ ");
                for (int i = 0; i < mappings.length; ++i) {
                    writer.print(Escape.htmlElementContent(mappings[i]));
                    if (i >= mappings.length - 1) continue;
                    writer.print(" , ");
                }
                writer.print(" ] ");
            }
            writer.print("</h2>");
            writer.print("<p>");
            writer.print(" Processing time: ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "processingTime"), true));
            writer.print(" Max time: ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "maxTime"), false));
            writer.print(" Request count: ");
            writer.print(mBeanServer.getAttribute(objectName, "requestCount"));
            writer.print(" Error count: ");
            writer.print(mBeanServer.getAttribute(objectName, "errorCount"));
            writer.print(" Load time: ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "loadTime"), false));
            writer.print(" Classloading time: ");
            writer.print(StatusTransformer.formatTime(mBeanServer.getAttribute(objectName, "classLoadTime"), false));
            writer.print("</p>");
        } else if (mode != 1 && mode == 2) {
            StatusTransformer.indent(writer, 4).append('{');
            StatusTransformer.appendJSonValue(writer, "servletName", JSONFilter.escape(servletName)).append(',');
            StatusTransformer.appendJSonValue(writer, "processingTime", mBeanServer.getAttribute(objectName, "processingTime")).append(',');
            StatusTransformer.appendJSonValue(writer, "maxTime", mBeanServer.getAttribute(objectName, "maxTime")).append(',');
            StatusTransformer.appendJSonValue(writer, "requestCount", mBeanServer.getAttribute(objectName, "requestCount")).append(',');
            StatusTransformer.appendJSonValue(writer, "errorCount", mBeanServer.getAttribute(objectName, "errorCount")).append(',');
            StatusTransformer.appendJSonValue(writer, "loadTime", mBeanServer.getAttribute(objectName, "loadTime")).append(',');
            StatusTransformer.appendJSonValue(writer, "classLoadTime", mBeanServer.getAttribute(objectName, "classLoadTime"));
            writer.append('}');
        }
    }

    public static String formatSize(Object obj, boolean mb) {
        long bytes = -1L;
        if (obj instanceof Long) {
            bytes = (Long)obj;
        } else if (obj instanceof Integer) {
            bytes = ((Integer)obj).intValue();
        }
        if (mb) {
            StringBuilder buff = new StringBuilder();
            if (bytes < 0L) {
                buff.append('-');
                bytes = -bytes;
            }
            long mbytes = bytes / 0x100000L;
            long rest = (bytes - mbytes * 0x100000L) * 100L / 0x100000L;
            buff.append(mbytes).append('.');
            if (rest < 10L) {
                buff.append('0');
            }
            buff.append(rest).append(" MiB");
            return buff.toString();
        }
        return bytes / 1024L + " KiB";
    }

    public static String formatTime(Object obj, boolean seconds) {
        long time = -1L;
        if (obj instanceof Long) {
            time = (Long)obj;
        } else if (obj instanceof Integer) {
            time = ((Integer)obj).intValue();
        }
        if (seconds) {
            return (float)time / 1000.0f + " s";
        }
        return time + " ms";
    }

    public static String formatSeconds(Object obj) {
        long time = -1L;
        if (obj instanceof Long) {
            time = (Long)obj;
        } else if (obj instanceof Integer) {
            time = ((Integer)obj).intValue();
        }
        return time + " s";
    }
}

