/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TException;
import com.facebook.thrift.TProcessorEventHandler;
import com.facebook.thrift.server.TConnectionContext;
import java.util.ArrayList;

public class EventHandlerBase {
    private int setEventHandlerPos_ = -1;
    private ContextStack s_ = null;
    public ArrayList<TProcessorEventHandler> handlers = new ArrayList();
    public TProcessorEventHandler eventHandler_;

    public void addEventHandler(TProcessorEventHandler handler) {
        this.handlers.add(handler);
    }

    public void clearEventHandlers() {
        this.handlers.clear();
        this.setEventHandlerPos_ = -1;
        if (this.eventHandler_ != null) {
            this.setEventHandler(this.eventHandler_);
        }
    }

    public TProcessorEventHandler getEventHandler() {
        return this.eventHandler_;
    }

    public void setEventHandler(TProcessorEventHandler eventHandler) {
        this.eventHandler_ = eventHandler;
        if (this.setEventHandlerPos_ > 0) {
            this.handlers.remove(this.setEventHandlerPos_ - 1);
        }
        this.setEventHandlerPos_ = this.handlers.size();
        this.handlers.add(eventHandler);
    }

    public ContextStack getContextStack() {
        return this.s_;
    }

    public void setContextStack(ContextStack s) {
        this.s_ = s;
    }

    protected ContextStack getContextStack(String fn_name, TConnectionContext connectionContext) {
        return new ContextStack(this.handlers, fn_name, connectionContext);
    }

    protected void preWrite(ContextStack s, String fn_name, TBase result) {
        if (s != null) {
            for (int i = 0; i < this.handlers.size(); ++i) {
                try {
                    this.handlers.get(i).preWrite(s.ctxs.get(i), fn_name, result);
                    continue;
                }
                catch (TException tException) {
                    // empty catch block
                }
            }
        }
    }

    protected void postWrite(ContextStack s, String fn_name, TBase result) {
        if (s != null) {
            for (int i = 0; i < this.handlers.size(); ++i) {
                try {
                    this.handlers.get(i).postWrite(s.ctxs.get(i), fn_name, result);
                    continue;
                }
                catch (TException tException) {
                    // empty catch block
                }
            }
        }
    }

    protected void preRead(ContextStack s, String fn_name) {
        if (s != null) {
            for (int i = 0; i < this.handlers.size(); ++i) {
                try {
                    this.handlers.get(i).preRead(s.ctxs.get(i), fn_name);
                    continue;
                }
                catch (TException tException) {
                    // empty catch block
                }
            }
        }
    }

    protected void postRead(ContextStack s, String fn_name, TBase args) {
        if (s != null) {
            for (int i = 0; i < this.handlers.size(); ++i) {
                try {
                    this.handlers.get(i).postRead(s.ctxs.get(i), fn_name, args);
                    continue;
                }
                catch (TException tException) {
                    // empty catch block
                }
            }
        }
    }

    protected void handlerError(ContextStack s, String fn_name, Throwable th) {
        if (s != null) {
            for (int i = 0; i < this.handlers.size(); ++i) {
                try {
                    this.handlers.get(i).handlerError(s.ctxs.get(i), fn_name, th);
                    continue;
                }
                catch (TException tException) {
                    // empty catch block
                }
            }
        }
    }

    public static class ContextStack {
        private ArrayList<Object> ctxs = new ArrayList();

        public ContextStack(ArrayList<TProcessorEventHandler> handlers, String method, TConnectionContext connectionContext) {
            for (TProcessorEventHandler handler : handlers) {
                this.ctxs.add(handler.getContext(method, connectionContext));
            }
        }
    }
}

