/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.csv;

import cn.afterturn.easypoi.csv.entity.CsvExportParams;
import cn.afterturn.easypoi.csv.export.CsvExportService;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.handler.inter.IExcelExportServer;
import cn.afterturn.easypoi.handler.inter.IWriter;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;

public final class CsvExportUtil {
    private CsvExportUtil() {
    }

    public static void exportCsv(CsvExportParams params, Class<?> pojoClass, Collection<?> dataSet, OutputStream outputStream) {
        CsvExportService writer = new CsvExportService(outputStream, params, pojoClass);
        writer.write(dataSet);
        writer.close();
    }

    public static void exportCsv(CsvExportParams params, Class<?> pojoClass, IExcelExportServer server, Object queryParams, OutputStream outputStream) {
        List<Object> dataSet;
        CsvExportService writer = new CsvExportService(outputStream, params, pojoClass);
        int page = 1;
        while ((dataSet = server.selectListForExcelExport(queryParams, page)) != null && dataSet.size() > 0) {
            ++page;
            writer.write(dataSet);
        }
        writer.close();
    }

    public static IWriter<Void> exportCsv(CsvExportParams params, Class<?> pojoClass, OutputStream outputStream) {
        return new CsvExportService(outputStream, params, pojoClass);
    }

    public static IWriter<Void> exportCsv(CsvExportParams params, List<ExcelExportEntity> entityList, OutputStream outputStream) {
        return new CsvExportService(outputStream, params, entityList);
    }
}

