/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools.commandtools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.helix.AccessOption;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.CurrentState;
import org.apache.helix.tools.commandtools.ToolsUtil;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.DataUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentStateCleanUp {
    private static final Logger LOG = LoggerFactory.getLogger(CurrentStateCleanUp.class);
    public static final String zkServer = "zkSvr";
    public static final String cluster = "cluster";
    public static final String instance = "instance";
    public static final String session = "session";
    public static final String help = "help";

    private static Options parseCommandLineOptions() {
        OptionBuilder.withLongOpt((String)help);
        OptionBuilder.withDescription((String)"Prints command-line options info");
        Option helpOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)zkServer);
        OptionBuilder.withDescription((String)"Provide zookeeper address");
        Option zkServerOption = OptionBuilder.create();
        zkServerOption.setArgs(1);
        zkServerOption.setRequired(true);
        zkServerOption.setArgName("ZookeeperServerAddress(Required)");
        OptionBuilder.withLongOpt((String)cluster);
        OptionBuilder.withDescription((String)"Provide cluster name");
        Option clusterOption = OptionBuilder.create();
        clusterOption.setArgs(1);
        clusterOption.setRequired(true);
        clusterOption.setArgName("Cluster name (Required)");
        OptionBuilder.withLongOpt((String)instance);
        OptionBuilder.withDescription((String)"Provide instance name");
        Option instanceOption = OptionBuilder.create();
        instanceOption.setArgs(1);
        instanceOption.setRequired(true);
        instanceOption.setArgName("Instance name");
        OptionBuilder.withLongOpt((String)session);
        OptionBuilder.withDescription((String)"Provide instance session");
        Option sessionOption = OptionBuilder.create();
        sessionOption.setArgs(1);
        sessionOption.setRequired(true);
        sessionOption.setArgName("Session name");
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.addOption(zkServerOption);
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(clusterOption);
        options.addOption(instanceOption);
        options.addOption(sessionOption);
        options.addOptionGroup(optionGroup);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupCurrentStatesForCluster(String zkConnectString, String clusterName, String instanceName, String session) throws Exception {
        HelixManager manager = HelixManagerFactory.getZKHelixManager(clusterName, "Administrator", InstanceType.ADMINISTRATOR, zkConnectString);
        manager.connect();
        try {
            HelixDataAccessor accessor = manager.getHelixDataAccessor();
            DataUpdater<ZNRecord> updater = new DataUpdater<ZNRecord>(){

                @Override
                public ZNRecord update(ZNRecord currentData) {
                    if (currentData == null) {
                        return null;
                    }
                    HashSet<String> partitionToRemove = new HashSet<String>();
                    for (String partition : currentData.getMapFields().keySet()) {
                        if (!currentData.getMapField(partition).get("CURRENT_STATE").equals(HelixDefinedState.DROPPED.name())) continue;
                        partitionToRemove.add(partition);
                    }
                    currentData.getMapFields().keySet().removeAll(partitionToRemove);
                    return currentData;
                }
            };
            LOG.info(String.format("Processing cleaning current state for instance: %s", instanceName));
            List<String> currentStateNames = accessor.getChildNames(accessor.keyBuilder().currentStates(instanceName, session));
            List<String> taskCurrentStateNames = accessor.getChildNames(accessor.keyBuilder().taskCurrentStates(instanceName, session));
            ArrayList allCurrentStateKeys = new ArrayList();
            currentStateNames.stream().map(name -> accessor.keyBuilder().currentState(instanceName, session, (String)name)).forEach(allCurrentStateKeys::add);
            taskCurrentStateNames.stream().map(name -> accessor.keyBuilder().taskCurrentState(instanceName, session, (String)name)).forEach(allCurrentStateKeys::add);
            ArrayList<String> pathsToRemove = new ArrayList<String>();
            for (PropertyKey key : allCurrentStateKeys) {
                accessor.getBaseDataAccessor().update(key.getPath(), updater, AccessOption.PERSISTENT);
                CurrentState currentState = (CurrentState)accessor.getProperty(key);
                if (currentState.getPartitionStateMap().size() != 0) continue;
                pathsToRemove.add(key.getPath());
                LOG.info(String.format("Remove current state for path %s", key.getPath()));
            }
            accessor.getBaseDataAccessor().remove(pathsToRemove, AccessOption.PERSISTENT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            manager.disconnect();
        }
    }

    public static void printUsage(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(1000);
        helpFormatter.printHelp("java " + CurrentStateCleanUp.class.getName(), cliOptions);
    }

    public static void main(String[] args) throws Exception {
        CommandLine cmd = ToolsUtil.processCommandLineArgs(args, CurrentStateCleanUp.parseCommandLineOptions());
        String zkConnectString = cmd.getOptionValue(zkServer);
        String clusterName = cmd.getOptionValue(cluster);
        String instanceName = cmd.getOptionValue(instance);
        String sessionId = cmd.getOptionValue(session);
        LOG.info(String.format("Starting cleaning current state with ZK: %s, cluster: %s", zkConnectString, clusterName));
        CurrentStateCleanUp.cleanupCurrentStatesForCluster(zkConnectString, clusterName, instanceName, sessionId);
    }
}

