/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import org.apache.helix.controller.rebalancer.waged.constraints.HardConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;

class SamePartitionOnInstanceConstraint
extends HardConstraint {
    SamePartitionOnInstanceConstraint() {
    }

    @Override
    boolean isAssignmentValid(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        return !node.getAssignedPartitionsByResource(replica.getResourceName()).contains(replica.getPartitionName());
    }

    @Override
    String getDescription() {
        return "Same partition of different states cannot co-exist in one instance";
    }
}

