/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ban.status;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.ban.status.AuthenticationFailureStatus;
import org.apache.guacamole.auth.ban.status.AuthenticationFailureTracker;
import org.apache.guacamole.language.TranslatableGuacamoleClientTooManyException;
import org.apache.guacamole.net.auth.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryAuthenticationFailureTracker
implements AuthenticationFailureTracker {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryAuthenticationFailureTracker.class);
    private final Cache<String, AuthenticationFailureStatus> failures;
    private final int maxAttempts;
    private final int banDuration;

    public InMemoryAuthenticationFailureTracker(int maxAttempts, int banDuration, long maxAddresses) {
        this.maxAttempts = maxAttempts;
        this.banDuration = banDuration;
        this.failures = Caffeine.newBuilder().maximumSize(maxAddresses).build();
    }

    private AuthenticationFailureStatus getAuthenticationFailure(String address) {
        AuthenticationFailureStatus status = (AuthenticationFailureStatus)this.failures.get((Object)address, addr -> new AuthenticationFailureStatus(this.maxAttempts, this.banDuration));
        status.notifyFailed();
        return status;
    }

    private void notifyAuthenticationStatus(Credentials credentials, boolean failed) throws GuacamoleException {
        AuthenticationFailureStatus status;
        if (credentials.isEmpty()) {
            return;
        }
        String address = credentials.getRemoteAddress();
        if (address == null) {
            throw new GuacamoleServerException("Source address cannot be determined.");
        }
        if (failed) {
            status = this.getAuthenticationFailure(address);
            logger.info("Authentication has failed for address \"{}\" (current total failures: {}/{}).", new Object[]{address, status.getFailures(), this.maxAttempts});
        } else {
            status = (AuthenticationFailureStatus)this.failures.getIfPresent((Object)address);
        }
        if (status != null) {
            if (status.isBlocked()) {
                logger.warn("Blocking authentication attempt from address \"{}\" due to number of authentication failures.", (Object)address);
                throw new TranslatableGuacamoleClientTooManyException("Too many failed authentication attempts.", "LOGIN.ERROR_TOO_MANY_ATTEMPTS");
            }
            if (!status.isValid()) {
                logger.debug("Removing address \"{}\" from tracking as there are no recent authentication failures.", (Object)address);
                this.failures.invalidate((Object)address);
            }
        }
    }

    @Override
    public void notifyAuthenticationRequestReceived(Credentials credentials) throws GuacamoleException {
        this.notifyAuthenticationStatus(credentials, false);
    }

    @Override
    public void notifyAuthenticationSuccess(Credentials credentials) throws GuacamoleException {
        this.notifyAuthenticationStatus(credentials, false);
    }

    @Override
    public void notifyAuthenticationFailed(Credentials credentials) throws GuacamoleException {
        this.notifyAuthenticationStatus(credentials, true);
    }
}

