/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package bugs

import groovy.test.GroovyTestCase

class Groovy3894Bug extends GroovyTestCase {
    void testInfinityToBigDecimalConversion() {
        BigDecimal x = 999999999999999999999999999999999999999999999999999999999999999999999999999999999999999
        assert x ** 5 == Double.POSITIVE_INFINITY
        try {
            BigDecimal y = x ** 5
        } catch (NumberFormatException nfe) {
            assert nfe.message == 'Infinite or NaN'
        }

        x = -999999999999999999999999999999999999999999999999999999999999999999999999999999999999999
        assert x ** 5 == Double.NEGATIVE_INFINITY
        try {
            BigDecimal y = x ** 5
        } catch (NumberFormatException nfe) {
            assert nfe.message == 'Infinite or NaN'
        }
    }
}
