/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace;

import com.lancedb.lance.namespace.LanceNamespace;
import com.lancedb.lance.namespace.model.ListNamespacesRequest;
import com.lancedb.lance.namespace.model.ListNamespacesResponse;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ListNamespacesIterable
implements Iterable<String> {
    private final LanceNamespace namespace;
    private final ListNamespacesRequest initialRequest;

    public ListNamespacesIterable(LanceNamespace namespace, ListNamespacesRequest initialRequest) {
        this.namespace = namespace;
        this.initialRequest = initialRequest;
    }

    @Override
    public Iterator<String> iterator() {
        return new ListNamespacesIterator();
    }

    private class ListNamespacesIterator
    implements Iterator<String> {
        private Iterator<String> currentPageIterator;
        private String nextPageToken;
        private boolean hasMorePages = true;
        private boolean initialized = false;

        private ListNamespacesIterator() {
        }

        @Override
        public boolean hasNext() {
            this.ensureInitialized();
            if (this.currentPageIterator != null && this.currentPageIterator.hasNext()) {
                return true;
            }
            if (!this.hasMorePages) {
                return false;
            }
            this.loadNextPage();
            return this.currentPageIterator != null && this.currentPageIterator.hasNext();
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more namespace names available");
            }
            return this.currentPageIterator.next();
        }

        private void ensureInitialized() {
            if (!this.initialized) {
                this.loadNextPage();
                this.initialized = true;
            }
        }

        private void loadNextPage() {
            try {
                ListNamespacesRequest request = new ListNamespacesRequest().id(ListNamespacesIterable.this.initialRequest.getId()).limit(ListNamespacesIterable.this.initialRequest.getLimit()).pageToken(this.nextPageToken);
                ListNamespacesResponse response = ListNamespacesIterable.this.namespace.listNamespaces(request);
                Set namespaces = response.getNamespaces();
                this.currentPageIterator = namespaces != null ? namespaces.iterator() : null;
                this.nextPageToken = response.getPageToken();
                this.hasMorePages = this.nextPageToken != null && !this.nextPageToken.isEmpty();
            }
            catch (Exception e) {
                this.hasMorePages = false;
                this.currentPageIterator = null;
                throw new RuntimeException("Failed to load namespace names", e);
            }
        }
    }
}

