/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.avro.InvalidAvroMagicException;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.common.DynClasses;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.DelegatingInputStream;
import org.apache.iceberg.io.SeekableInputStream;

class AvroIO {
    private static final byte[] AVRO_MAGIC = new byte[]{79, 98, 106, 1};
    private static final ValueReader<byte[]> MAGIC_READER = ValueReaders.fixed(AVRO_MAGIC.length);
    private static final ValueReader<Map<String, String>> META_READER = ValueReaders.map(ValueReaders.strings(), ValueReaders.strings());
    private static final ValueReader<byte[]> SYNC_READER = ValueReaders.fixed(16);
    private static final Class<?> FS_DATA_INPUT_STREAM_CLASS = DynClasses.builder().impl("org.apache.hadoop.fs.FSDataInputStream").orNull().build();
    private static final boolean RELOCATED = "org.apache.avro.file.SeekableInput".equals(SeekableInput.class.getName());
    private static final DynConstructors.Ctor<SeekableInput> AVRO_FS_INPUT_CTOR = !RELOCATED && FS_DATA_INPUT_STREAM_CLASS != null ? DynConstructors.builder(SeekableInput.class).impl("org.apache.hadoop.fs.AvroFSInput", new Class[]{FS_DATA_INPUT_STREAM_CLASS, Long.TYPE}).build() : null;

    private AvroIO() {
    }

    static SeekableInput stream(SeekableInputStream stream, long length) {
        if (stream instanceof DelegatingInputStream) {
            InputStream wrapped = ((DelegatingInputStream)stream).getDelegate();
            if (AVRO_FS_INPUT_CTOR != null && FS_DATA_INPUT_STREAM_CLASS != null && FS_DATA_INPUT_STREAM_CLASS.isInstance(wrapped)) {
                return (SeekableInput)AVRO_FS_INPUT_CTOR.newInstance(new Object[]{wrapped, length});
            }
        }
        return new AvroInputStreamAdapter(stream, length);
    }

    static long findStartingRowPos(Supplier<SeekableInputStream> open, long start) {
        long l;
        block13: {
            long totalRows = 0L;
            SeekableInputStream in = open.get();
            try {
                BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder((InputStream)in, null);
                byte[] magic = MAGIC_READER.read((Decoder)decoder, null);
                if (!Arrays.equals(AVRO_MAGIC, magic)) {
                    throw new InvalidAvroMagicException("Not an Avro file");
                }
                META_READER.read((Decoder)decoder, null);
                byte[] fileSync = SYNC_READER.read((Decoder)decoder, null);
                byte[] blockSync = new byte[16];
                long nextSyncPos = in.getPos();
                while (nextSyncPos < start) {
                    if (nextSyncPos != in.getPos()) {
                        in.seek(nextSyncPos);
                        SYNC_READER.read((Decoder)decoder, blockSync);
                        if (!Arrays.equals(fileSync, blockSync)) {
                            throw new RuntimeIOException("Invalid sync at %s", new Object[]{nextSyncPos});
                        }
                    }
                    long rowCount = decoder.readLong();
                    long compressedBlockSize = decoder.readLong();
                    totalRows += rowCount;
                    nextSyncPos = in.getPos() + compressedBlockSize;
                }
                l = totalRows;
                if (in == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (EOFException e) {
                    return totalRows;
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e, "Failed to read stream while finding starting row position", new Object[0]);
                }
            }
            in.close();
        }
        return l;
    }

    private static class AvroInputStreamAdapter
    extends SeekableInputStream
    implements SeekableInput {
        private final SeekableInputStream stream;
        private final long length;

        AvroInputStreamAdapter(SeekableInputStream stream, long length) {
            this.stream = stream;
            this.length = length;
        }

        public void close() throws IOException {
            this.stream.close();
        }

        public long getPos() throws IOException {
            return this.stream.getPos();
        }

        public void seek(long newPos) throws IOException {
            this.stream.seek(newPos);
        }

        public long tell() throws IOException {
            return this.getPos();
        }

        public long length() throws IOException {
            return this.length;
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.stream.skip(n);
        }

        public int available() throws IOException {
            return this.stream.available();
        }

        public synchronized void mark(int readlimit) {
            this.stream.mark(readlimit);
        }

        public synchronized void reset() throws IOException {
            this.stream.reset();
        }

        public boolean markSupported() {
            return this.stream.markSupported();
        }
    }
}

