/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.converters;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.storage.relational.converters.SQLExceptionConverter;

public class MySQLExceptionConverter
implements SQLExceptionConverter {
    static final int DUPLICATED_ENTRY_ERROR_CODE = 1062;

    @Override
    public void toGravitinoException(SQLException se, Entity.EntityType type, String name) throws IOException {
        switch (se.getErrorCode()) {
            case 1062: {
                throw new EntityAlreadyExistsException(se, "The %s entity: %s already exists.", type.name(), name);
            }
        }
        throw new IOException(se);
    }
}

