/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lineage.sink;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openlineage.server.OpenLineage;
import org.apache.gravitino.lineage.Utils;
import org.apache.gravitino.lineage.sink.LineageSink;
import org.apache.gravitino.server.web.ObjectMapperProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineageLogSink
implements LineageSink {
    private static final Logger LOG = LoggerFactory.getLogger(LineageLogSink.class);
    private ObjectMapper objectMapper = ObjectMapperProvider.objectMapper();
    private LineageLogger logger = new LineageLogger();

    @Override
    public void sink(OpenLineage.RunEvent event) {
        try {
            this.logger.log(this.objectMapper.writeValueAsString((Object)event));
        }
        catch (JsonProcessingException e) {
            LOG.warn("Process open lineage event failed, run id: {}, error message: {}", (Object)Utils.getRunID(event), (Object)e.getMessage());
        }
    }

    private static class LineageLogger {
        private static final Logger LINEAGE_LOG = LoggerFactory.getLogger(LineageLogger.class);

        private LineageLogger() {
        }

        public void log(String lineageString) {
            LINEAGE_LOG.info(lineageString);
        }
    }
}

