/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lineage;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Config;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;
import org.apache.gravitino.lineage.processor.NoopProcessor;
import org.apache.gravitino.lineage.sink.LineageLogSink;
import org.apache.gravitino.lineage.source.HTTPLineageSource;

public class LineageConfig
extends Config {
    public static final String LINEAGE_CONFIG_PREFIX = "gravitino.lineage.";
    public static final String LINEAGE_CONFIG_SINKS = "sinks";
    public static final String LINEAGE_SINK_QUEUE_CAPACITY = "sinkQueueCapacity";
    public static final String LINEAGE_CONFIG_SOURCE = "source";
    public static final String LINEAGE_SOURCE_CLASS_NAME = "sourceClass";
    public static final String LINEAGE_PROCESSOR_CLASS_NAME = "processorClass";
    public static final String LINEAGE_SINK_CLASS_NAME = "sinkClass";
    public static final String LINEAGE_HTTP_SOURCE_CLASS_NAME = HTTPLineageSource.class.getName();
    public static final String LINEAGE_LOG_SINK_NAME = "log";
    public static final String LINEAGE_HTTP_SOURCE_NAME = "http";
    @VisibleForTesting
    static final int LINEAGE_SINK_QUEUE_CAPACITY_DEFAULT = 10000;
    private static final Splitter splitter = Splitter.on((String)",");
    public static final ConfigEntry<String> SOURCE_NAME = new ConfigBuilder("source").doc("The name of lineage event source").version("0.9.0").stringConf().createWithDefault((Object)"http");
    public static final ConfigEntry<String> PROCESSOR_CLASS = new ConfigBuilder("processorClass").doc("The class name of lineage event processor").version("0.9.0").stringConf().createWithDefault((Object)NoopProcessor.class.getName());
    public static final ConfigEntry<String> SINKS = new ConfigBuilder("sinks").doc("The sinks of lineage event").version("0.9.0").stringConf().createWithDefault((Object)"log");
    public static final ConfigEntry<Integer> SINK_QUEUE_CAPACITY = new ConfigBuilder("sinkQueueCapacity").doc("The capacity of the total lineage sink queue").version("0.9.0").intConf().createWithDefault((Object)10000);

    public LineageConfig(Map<String, String> properties) {
        super(false);
        this.loadFromMap(properties, k -> true);
    }

    public String source() {
        return (String)this.get(SOURCE_NAME);
    }

    public String sourceClass() {
        if (this.source().equals(LINEAGE_HTTP_SOURCE_NAME)) {
            return LINEAGE_HTTP_SOURCE_CLASS_NAME;
        }
        String sourceConfig = this.source() + "." + LINEAGE_SOURCE_CLASS_NAME;
        String sourceClass = this.getRawString(sourceConfig);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)sourceClass), (Object)(sourceConfig + " is not set"));
        return sourceClass;
    }

    public String processorClass() {
        return (String)this.get(PROCESSOR_CLASS);
    }

    public Map<String, String> getSinkConfigs() {
        List<String> sinks = this.sinks();
        Map config = this.getAllConfig();
        HashMap<String, String> m = new HashMap<String, String>(config);
        String sinkString = (String)this.get(SINKS);
        if (!m.containsKey(LINEAGE_CONFIG_SINKS)) {
            m.put(LINEAGE_CONFIG_SINKS, sinkString);
        }
        if (!m.containsKey(LINEAGE_SINK_QUEUE_CAPACITY)) {
            m.put(LINEAGE_SINK_QUEUE_CAPACITY, String.valueOf(this.get(SINK_QUEUE_CAPACITY)));
        }
        String logClassConfigKey = "log.sinkClass";
        if (sinks.contains(LINEAGE_LOG_SINK_NAME) && !config.containsKey(logClassConfigKey)) {
            m.put(logClassConfigKey, LineageLogSink.class.getName());
        }
        sinks.stream().forEach(sinkName -> {
            String sinkClassConfig = sinkName + "." + LINEAGE_SINK_CLASS_NAME;
            Preconditions.checkArgument((boolean)m.containsKey(sinkClassConfig), (Object)(sinkClassConfig + " is not set"));
        });
        return m;
    }

    public List<String> sinks() {
        String sinks = (String)this.get(SINKS);
        return splitter.omitEmptyStrings().trimResults().splitToStream((CharSequence)sinks).collect(Collectors.toList());
    }
}

