/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergCatalogBackend;
import org.apache.gravitino.catalog.lakehouse.iceberg.IcebergPropertiesUtils;
import org.apache.gravitino.connector.BaseCatalogPropertiesMetadata;
import org.apache.gravitino.connector.PropertyEntry;
import org.apache.gravitino.iceberg.common.authentication.AuthenticationConfig;
import org.apache.gravitino.iceberg.common.authentication.kerberos.KerberosConfig;

public class IcebergCatalogPropertiesMetadata
extends BaseCatalogPropertiesMetadata {
    public static final String CATALOG_BACKEND = "catalog-backend";
    public static final String GRAVITINO_JDBC_USER = "jdbc-user";
    public static final String GRAVITINO_JDBC_PASSWORD = "jdbc-password";
    public static final String WAREHOUSE = "warehouse";
    public static final String URI = "uri";
    public static final String CATALOG_BACKEND_NAME = "catalog-backend-name";
    private static final Map<String, PropertyEntry<?>> PROPERTIES_METADATA;
    public static final Map<String, String> KERBEROS_CONFIGURATION_FOR_HIVE_BACKEND;

    protected Map<String, PropertyEntry<?>> specificPropertyEntries() {
        return PROPERTIES_METADATA;
    }

    public Map<String, String> transformProperties(Map<String, String> gravitinoProperties) {
        Map icebergProperties = IcebergPropertiesUtils.toIcebergCatalogProperties(gravitinoProperties);
        gravitinoProperties.forEach((k, v) -> {
            if (KERBEROS_CONFIGURATION_FOR_HIVE_BACKEND.containsKey(k)) {
                icebergProperties.put(KERBEROS_CONFIGURATION_FOR_HIVE_BACKEND.get(k), v);
            }
        });
        return icebergProperties;
    }

    static {
        KERBEROS_CONFIGURATION_FOR_HIVE_BACKEND = ImmutableMap.of((Object)"authentication.kerberos.principal", (Object)"authentication.kerberos.principal", (Object)"authentication.kerberos.keytab-uri", (Object)"authentication.kerberos.keytab-uri", (Object)"authentication.kerberos.check-interval-sec", (Object)"authentication.kerberos.check-interval-sec", (Object)"authentication.kerberos.keytab-fetch-timeout-sec", (Object)"authentication.kerberos.keytab-fetch-timeout-sec", (Object)"authentication.impersonation-enable", (Object)"authentication.impersonation-enable", (Object)"authentication.type", (Object)"authentication.type");
        ImmutableList propertyEntries = ImmutableList.of((Object)PropertyEntry.enumImmutablePropertyEntry((String)CATALOG_BACKEND, (String)"Iceberg catalog type choose properties", (boolean)true, IcebergCatalogBackend.class, null, (boolean)false, (boolean)false), (Object)PropertyEntry.stringRequiredPropertyEntry((String)URI, (String)"Iceberg catalog uri config", (boolean)false, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)WAREHOUSE, (String)"Iceberg catalog warehouse config", (boolean)false, null, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)"io-impl", (String)"FileIO implement for Iceberg", (boolean)true, null, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)"s3-access-key-id", (String)"s3 access key ID", (boolean)false, null, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)"s3-secret-access-key", (String)"s3 secret access key", (boolean)false, null, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)"oss-access-key-id", (String)"OSS access key ID", (boolean)false, null, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)"oss-secret-access-key", (String)"OSS access key secret", (boolean)false, null, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)"azure-storage-account-name", (String)"Azure storage account name", (boolean)false, null, (boolean)false), (Object)PropertyEntry.stringOptionalPropertyEntry((String)"azure-storage-account-key", (String)"Azure storage account key", (boolean)false, null, (boolean)false));
        HashMap result = Maps.newHashMap();
        result.putAll(Maps.uniqueIndex((Iterable)propertyEntries, PropertyEntry::getName));
        result.putAll(KerberosConfig.KERBEROS_PROPERTY_ENTRIES);
        result.putAll(AuthenticationConfig.AUTHENTICATION_PROPERTY_ENTRIES);
        PROPERTIES_METADATA = ImmutableMap.copyOf((Map)result);
    }
}

