/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xerial.snappy.pure;

import java.nio.ByteOrder;
import org.apache.hadoop.shaded.org.xerial.snappy.SnappyError;
import org.apache.hadoop.shaded.org.xerial.snappy.SnappyErrorCode;
import org.apache.hadoop.shaded.org.xerial.snappy.pure.UnsafeUtil;

public final class SnappyRawDecompressor {
    private static final int[] DEC_32_TABLE = new int[]{4, 1, 2, 1, 4, 4, 4, 4};
    private static final int[] DEC_64_TABLE = new int[]{0, 0, 0, -1, 0, 1, 2, 3};
    private static final ByteOrder byteOrder = ByteOrder.nativeOrder();
    private static final int[] wordmask = new int[]{0, 255, 65535, 0xFFFFFF, -1};
    private static final short[] opLookupTable = new short[]{1, 2052, 4097, 8193, 2, 2053, 4098, 8194, 3, 2054, 4099, 8195, 4, 2055, 4100, 8196, 5, 2056, 4101, 8197, 6, 2057, 4102, 8198, 7, 2058, 4103, 8199, 8, 2059, 4104, 8200, 9, 2308, 4105, 8201, 10, 2309, 4106, 8202, 11, 2310, 4107, 8203, 12, 2311, 4108, 8204, 13, 2312, 4109, 8205, 14, 2313, 4110, 8206, 15, 2314, 4111, 8207, 16, 2315, 4112, 8208, 17, 2564, 4113, 8209, 18, 2565, 4114, 8210, 19, 2566, 4115, 8211, 20, 2567, 4116, 8212, 21, 2568, 4117, 8213, 22, 2569, 4118, 8214, 23, 2570, 4119, 8215, 24, 2571, 4120, 8216, 25, 2820, 4121, 8217, 26, 2821, 4122, 8218, 27, 2822, 4123, 8219, 28, 2823, 4124, 8220, 29, 2824, 4125, 8221, 30, 2825, 4126, 8222, 31, 2826, 4127, 8223, 32, 2827, 4128, 8224, 33, 3076, 4129, 8225, 34, 3077, 4130, 8226, 35, 3078, 4131, 8227, 36, 3079, 4132, 8228, 37, 3080, 4133, 8229, 38, 3081, 4134, 8230, 39, 3082, 4135, 8231, 40, 3083, 4136, 8232, 41, 3332, 4137, 8233, 42, 3333, 4138, 8234, 43, 3334, 4139, 8235, 44, 3335, 4140, 8236, 45, 3336, 4141, 8237, 46, 3337, 4142, 8238, 47, 3338, 4143, 8239, 48, 3339, 4144, 8240, 49, 3588, 4145, 8241, 50, 3589, 4146, 8242, 51, 3590, 4147, 8243, 52, 3591, 4148, 8244, 53, 3592, 4149, 8245, 54, 3593, 4150, 8246, 55, 3594, 4151, 8247, 56, 3595, 4152, 8248, 57, 3844, 4153, 8249, 58, 3845, 4154, 8250, 59, 3846, 4155, 8251, 60, 3847, 4156, 8252, 2049, 3848, 4157, 8253, 4097, 3849, 4158, 8254, 6145, 3850, 4159, 8255, 8193, 3851, 4160, 8256};

    private SnappyRawDecompressor() {
    }

    private static int littleEndian(int n) {
        return byteOrder == ByteOrder.LITTLE_ENDIAN ? n : Integer.reverseBytes(n);
    }

    public static int getUncompressedLength(Object object, long l, long l2) {
        return SnappyRawDecompressor.readUncompressedLength(object, l, l2)[0];
    }

    public static int decompress(Object object, long l, long l2, Object object2, long l3, long l4) {
        long l5 = l;
        int[] nArray = SnappyRawDecompressor.readUncompressedLength(object, l5, l2);
        int n = nArray[0];
        l5 += (long)nArray[1];
        if ((long)n > l4 - l3) {
            throw new SnappyError(SnappyErrorCode.INVALID_CHUNK_SIZE, String.format("Uncompressed length %s must be less than %s", n, l4 - l3));
        }
        int n2 = SnappyRawDecompressor.uncompressAll(object, l5, l2, object2, l3, l4);
        if (n != n2) {
            throw new SnappyError(SnappyErrorCode.INVALID_CHUNK_SIZE, String.format("Recorded length is %s bytes but actual length after decompression is %s bytes ", n, n2));
        }
        return n;
    }

    private static int uncompressAll(Object object, long l, long l2, Object object2, long l3, long l4) {
        long l5 = l4 - 8L;
        long l6 = l3;
        long l7 = l;
        while (l7 < l2) {
            long l8;
            int n;
            int n2 = UnsafeUtil.UNSAFE.getByte(object, l7++) & 0xFF;
            int n3 = opLookupTable[n2] & 0xFFFF;
            int n4 = n3 >>> 11;
            int n5 = 0;
            if (l7 + 4L < l2) {
                n5 = SnappyRawDecompressor.littleEndian(UnsafeUtil.UNSAFE.getInt(object, l7)) & wordmask[n4];
            } else {
                if (l7 + (long)n4 > l2) {
                    throw new SnappyError(SnappyErrorCode.PARSING_ERROR, String.format("position: %d", l7 - l));
                }
                switch (n4) {
                    case 4: {
                        n5 = (UnsafeUtil.UNSAFE.getByte(object, l7 + 3L) & 0xFF) << 24;
                    }
                    case 3: {
                        n5 |= (UnsafeUtil.UNSAFE.getByte(object, l7 + 2L) & 0xFF) << 16;
                    }
                    case 2: {
                        n5 |= (UnsafeUtil.UNSAFE.getByte(object, l7 + 1L) & 0xFF) << 8;
                    }
                    case 1: {
                        n5 |= UnsafeUtil.UNSAFE.getByte(object, l7) & 0xFF;
                    }
                }
            }
            if (n5 < 0) {
                throw new SnappyError(SnappyErrorCode.PARSING_ERROR, String.format("position: %d", l7 - l));
            }
            l7 += (long)n4;
            int n6 = n3 & 0xFF;
            if (n6 == 0) continue;
            if ((n2 & 3) == 0) {
                n = n6 + n5;
                l8 = l6 + (long)n;
                if (l8 > l5 || l7 + (long)n > l2 - 8L) {
                    if (l8 > l4) {
                        throw new SnappyError(SnappyErrorCode.PARSING_ERROR, String.format("position: %d", l7 - l));
                    }
                    UnsafeUtil.UNSAFE.copyMemory(object, l7, object2, l6, n);
                    l7 += (long)n;
                    l6 += (long)n;
                    continue;
                }
                do {
                    UnsafeUtil.UNSAFE.putLong(object2, l6, UnsafeUtil.UNSAFE.getLong(object, l7));
                    l7 += 8L;
                } while ((l6 += 8L) < l8);
                l7 -= l6 - l8;
                l6 = l8;
                continue;
            }
            n = n3 & 0x700;
            l8 = l6 - (long)(n += n5);
            if (l8 < l3 || l6 + (long)n6 > l4) {
                throw new SnappyError(SnappyErrorCode.PARSING_ERROR, String.format("position: %d", l7 - l));
            }
            long l9 = l6 + (long)n6;
            if (l6 > l5) {
                while (l6 < l9) {
                    UnsafeUtil.UNSAFE.putByte(object2, l6++, UnsafeUtil.UNSAFE.getByte(object2, l8++));
                }
            } else {
                if (n < 8) {
                    int n7 = DEC_32_TABLE[n];
                    int n8 = DEC_64_TABLE[n];
                    UnsafeUtil.UNSAFE.putByte(object2, l6, UnsafeUtil.UNSAFE.getByte(object2, l8));
                    UnsafeUtil.UNSAFE.putByte(object2, l6 + 1L, UnsafeUtil.UNSAFE.getByte(object2, l8 + 1L));
                    UnsafeUtil.UNSAFE.putByte(object2, l6 + 2L, UnsafeUtil.UNSAFE.getByte(object2, l8 + 2L));
                    UnsafeUtil.UNSAFE.putByte(object2, l6 + 3L, UnsafeUtil.UNSAFE.getByte(object2, l8 + 3L));
                    UnsafeUtil.UNSAFE.putInt(object2, l6 += 4L, UnsafeUtil.UNSAFE.getInt(object2, l8 += (long)n7));
                    l6 += 4L;
                    l8 -= (long)n8;
                } else {
                    UnsafeUtil.UNSAFE.putLong(object2, l6, UnsafeUtil.UNSAFE.getLong(object2, l8));
                    l8 += 8L;
                    l6 += 8L;
                }
                if (l9 > l5) {
                    if (l9 > l4) {
                        throw new SnappyError(SnappyErrorCode.PARSING_ERROR, String.format("position: %d", l7 - l));
                    }
                    while (l6 < l5) {
                        UnsafeUtil.UNSAFE.putLong(object2, l6, UnsafeUtil.UNSAFE.getLong(object2, l8));
                        l8 += 8L;
                        l6 += 8L;
                    }
                    while (l6 < l9) {
                        UnsafeUtil.UNSAFE.putByte(object2, l6++, UnsafeUtil.UNSAFE.getByte(object2, l8++));
                    }
                } else {
                    while (l6 < l9) {
                        UnsafeUtil.UNSAFE.putLong(object2, l6, UnsafeUtil.UNSAFE.getLong(object2, l8));
                        l8 += 8L;
                        l6 += 8L;
                    }
                }
            }
            l6 = l9;
        }
        return (int)(l6 - l3);
    }

    static int[] readUncompressedLength(Object object, long l, long l2) {
        int n = 0;
        int n2 = SnappyRawDecompressor.getUnsignedByteSafe(object, l + (long)n, l2);
        ++n;
        int n3 = n2 & 0x7F;
        if ((n2 & 0x80) != 0) {
            n2 = SnappyRawDecompressor.getUnsignedByteSafe(object, l + (long)n, l2);
            ++n;
            n3 |= (n2 & 0x7F) << 7;
            if ((n2 & 0x80) != 0) {
                n2 = SnappyRawDecompressor.getUnsignedByteSafe(object, l + (long)n, l2);
                ++n;
                n3 |= (n2 & 0x7F) << 14;
                if ((n2 & 0x80) != 0) {
                    n2 = SnappyRawDecompressor.getUnsignedByteSafe(object, l + (long)n, l2);
                    ++n;
                    n3 |= (n2 & 0x7F) << 21;
                    if ((n2 & 0x80) != 0) {
                        n2 = SnappyRawDecompressor.getUnsignedByteSafe(object, l + (long)n, l2);
                        ++n;
                        n3 |= (n2 & 0x7F) << 28;
                        if ((n2 & 0x80) != 0) {
                            throw new SnappyError(SnappyErrorCode.PARSING_ERROR, String.format("position: %d, error: %s", l + (long)n, "last byte of compressed length int has high bit set"));
                        }
                    }
                }
            }
        }
        return new int[]{n3, n};
    }

    private static int getUnsignedByteSafe(Object object, long l, long l2) {
        if (l >= l2) {
            throw new SnappyError(SnappyErrorCode.PARSING_ERROR, String.format("position: %d, error: %s", l2 - l, "Input is truncated"));
        }
        return UnsafeUtil.UNSAFE.getByte(object, l) & 0xFF;
    }
}

