/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.audit.CallerContext;
import org.apache.gravitino.client.BaseSchemaCatalog;
import org.apache.gravitino.client.DTOConverters;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.GenericFileset;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.SupportsCredentials;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.dto.CatalogDTO;
import org.apache.gravitino.dto.requests.FilesetCreateRequest;
import org.apache.gravitino.dto.requests.FilesetUpdatesRequest;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.EntityListResponse;
import org.apache.gravitino.dto.responses.FileLocationResponse;
import org.apache.gravitino.dto.responses.FilesetResponse;
import org.apache.gravitino.exceptions.FilesetAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchFilesetException;
import org.apache.gravitino.exceptions.NoSuchLocationNameException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.file.FilesetChange;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.rest.RESTUtils;

class FilesetCatalog
extends BaseSchemaCatalog
implements org.apache.gravitino.file.FilesetCatalog,
SupportsCredentials {
    FilesetCatalog(Namespace namespace, String name, Catalog.Type type, String provider, String comment, Map<String, String> properties, AuditDTO auditDTO, RESTClient restClient) {
        super(namespace, name, type, provider, comment, properties, auditDTO, restClient);
    }

    public org.apache.gravitino.file.FilesetCatalog asFilesetCatalog() throws UnsupportedOperationException {
        return this;
    }

    public NameIdentifier[] listFilesets(Namespace namespace) throws NoSuchSchemaException {
        FilesetCatalog.checkFilesetNamespace(namespace);
        Namespace fullNamespace = this.getFilesetFullNamespace(namespace);
        EntityListResponse resp = this.restClient.get(FilesetCatalog.formatFilesetRequestPath(fullNamespace), EntityListResponse.class, Collections.emptyMap(), ErrorHandlers.filesetErrorHandler());
        resp.validate();
        return (NameIdentifier[])Arrays.stream(resp.identifiers()).map(ident -> NameIdentifier.of((String[])new String[]{ident.namespace().level(2), ident.name()})).toArray(NameIdentifier[]::new);
    }

    public Fileset loadFileset(NameIdentifier ident) throws NoSuchFilesetException {
        FilesetCatalog.checkFilesetNameIdentifier(ident);
        Namespace fullNamespace = this.getFilesetFullNamespace(ident.namespace());
        FilesetResponse resp = this.restClient.get(FilesetCatalog.formatFilesetRequestPath(fullNamespace) + "/" + RESTUtils.encodeString((String)ident.name()), FilesetResponse.class, Collections.emptyMap(), ErrorHandlers.filesetErrorHandler());
        resp.validate();
        return new GenericFileset(resp.getFileset(), this.restClient, fullNamespace);
    }

    public Fileset createMultipleLocationFileset(NameIdentifier ident, String comment, Fileset.Type type, Map<String, String> storageLocations, Map<String, String> properties) throws NoSuchSchemaException, FilesetAlreadyExistsException {
        FilesetCatalog.checkFilesetNameIdentifier(ident);
        Namespace fullNamespace = this.getFilesetFullNamespace(ident.namespace());
        FilesetCreateRequest req = FilesetCreateRequest.builder().name(ident.name()).comment(comment).type(type).storageLocations(storageLocations).properties(properties).build();
        req.validate();
        FilesetResponse resp = this.restClient.post(FilesetCatalog.formatFilesetRequestPath(fullNamespace), (RESTRequest)req, FilesetResponse.class, Collections.emptyMap(), ErrorHandlers.filesetErrorHandler());
        resp.validate();
        return new GenericFileset(resp.getFileset(), this.restClient, fullNamespace);
    }

    public Fileset alterFileset(NameIdentifier ident, FilesetChange ... changes) throws NoSuchFilesetException, IllegalArgumentException {
        FilesetCatalog.checkFilesetNameIdentifier(ident);
        Namespace fullNamespace = this.getFilesetFullNamespace(ident.namespace());
        List updates = Arrays.stream(changes).map(DTOConverters::toFilesetUpdateRequest).collect(Collectors.toList());
        FilesetUpdatesRequest req = new FilesetUpdatesRequest(updates);
        req.validate();
        FilesetResponse resp = this.restClient.put(FilesetCatalog.formatFilesetRequestPath(fullNamespace) + "/" + RESTUtils.encodeString((String)ident.name()), (RESTRequest)req, FilesetResponse.class, Collections.emptyMap(), ErrorHandlers.filesetErrorHandler());
        resp.validate();
        return new GenericFileset(resp.getFileset(), this.restClient, fullNamespace);
    }

    public boolean dropFileset(NameIdentifier ident) {
        FilesetCatalog.checkFilesetNameIdentifier(ident);
        Namespace fullNamespace = this.getFilesetFullNamespace(ident.namespace());
        DropResponse resp = this.restClient.delete(FilesetCatalog.formatFilesetRequestPath(fullNamespace) + "/" + RESTUtils.encodeString((String)ident.name()), DropResponse.class, Collections.emptyMap(), ErrorHandlers.filesetErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileLocation(NameIdentifier ident, String subPath, String locationName) throws NoSuchFilesetException, NoSuchLocationNameException {
        FilesetCatalog.checkFilesetNameIdentifier(ident);
        Namespace fullNamespace = this.getFilesetFullNamespace(ident.namespace());
        try {
            CallerContext callerContext = CallerContext.CallerContextHolder.get();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sub_path", RESTUtils.encodeString((String)subPath));
            if (locationName != null) {
                params.put("location_name", RESTUtils.encodeString((String)locationName));
            }
            FileLocationResponse resp = this.restClient.get(FilesetCatalog.formatFileLocationRequestPath(fullNamespace, ident.name()), params, FileLocationResponse.class, callerContext != null ? callerContext.context() : Collections.emptyMap(), ErrorHandlers.filesetErrorHandler());
            resp.validate();
            String string = resp.getFileLocation();
            return string;
        }
        finally {
            CallerContext.CallerContextHolder.remove();
        }
    }

    public SupportsCredentials supportsCredentials() throws UnsupportedOperationException {
        return this;
    }

    public Credential[] getCredentials() {
        return this.objectCredentialOperations.getCredentials();
    }

    @VisibleForTesting
    static String formatFilesetRequestPath(Namespace ns) {
        Namespace schemaNs = Namespace.of((String[])new String[]{ns.level(0), ns.level(1)});
        return FilesetCatalog.formatSchemaRequestPath(schemaNs) + "/" + RESTUtils.encodeString((String)ns.level(2)) + "/filesets";
    }

    @VisibleForTesting
    static String formatFileLocationRequestPath(Namespace ns, String name) {
        Namespace schemaNs = Namespace.of((String[])new String[]{ns.level(0), ns.level(1)});
        return FilesetCatalog.formatSchemaRequestPath(schemaNs) + "/" + RESTUtils.encodeString((String)ns.level(2)) + "/filesets/" + RESTUtils.encodeString((String)name) + "/location";
    }

    static void checkFilesetNamespace(Namespace namespace) {
        Namespace.check((namespace != null && namespace.length() == 1 ? 1 : 0) != 0, (String)"Fileset namespace must be non-null and have 1 level, the input namespace is %s", (Object[])new Object[]{namespace});
    }

    static void checkFilesetNameIdentifier(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"NameIdentifier must not be null", (Object[])new Object[0]);
        NameIdentifier.check((ident.name() != null && !ident.name().isEmpty() ? 1 : 0) != 0, (String)"NameIdentifier name must not be empty", (Object[])new Object[0]);
        FilesetCatalog.checkFilesetNamespace(ident.namespace());
    }

    private Namespace getFilesetFullNamespace(Namespace filesetNamespace) {
        return Namespace.of((String[])new String[]{this.catalogNamespace().level(0), this.name(), filesetNamespace.level(0)});
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder
    extends CatalogDTO.Builder<Builder> {
        private RESTClient restClient;
        private Namespace namespace;

        private Builder() {
        }

        Builder withNamespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        Builder withRestClient(RESTClient restClient) {
            this.restClient = restClient;
            return this;
        }

        public FilesetCatalog build() {
            Namespace.check((this.namespace != null && this.namespace.length() == 1 ? 1 : 0) != 0, (String)"Catalog namespace must be non-null and have 1 level, the input namespace is %s", (Object[])new Object[]{this.namespace});
            Preconditions.checkArgument((this.restClient != null ? 1 : 0) != 0, (Object)"restClient must be set");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"name must not be blank");
            Preconditions.checkArgument((this.type != null ? 1 : 0) != 0, (Object)"type must not be null");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.provider), (Object)"provider must not be blank");
            Preconditions.checkArgument((this.audit != null ? 1 : 0) != 0, (Object)"audit must not be null");
            return new FilesetCatalog(this.namespace, this.name, this.type, this.provider, this.comment, this.properties, this.audit, this.restClient);
        }
    }
}

