/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.stats;

import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.paimon.casting.CastFieldGetter;
import org.apache.paimon.casting.CastedRow;
import org.apache.paimon.data.BinaryArray;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.stats.BinaryTableStats;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;

public class FieldStatsArraySerializer {
    private final InternalRowSerializer serializer;
    @Nullable
    private final int[] indexMapping;
    @Nullable
    private final CastFieldGetter[] castFieldGetters;

    public FieldStatsArraySerializer(RowType type) {
        this(type, null, null);
    }

    public FieldStatsArraySerializer(RowType type, @Nullable int[] indexMapping, @Nullable CastFieldGetter[] castFieldGetters) {
        RowType safeType = FieldStatsArraySerializer.toAllFieldsNullableRowType(type);
        this.serializer = new InternalRowSerializer(safeType);
        this.indexMapping = indexMapping;
        this.castFieldGetters = castFieldGetters;
    }

    public BinaryTableStats toBinary(FieldStats[] stats) {
        int rowFieldCount = stats.length;
        GenericRow minValues = new GenericRow(rowFieldCount);
        GenericRow maxValues = new GenericRow(rowFieldCount);
        Long[] nullCounts = new Long[rowFieldCount];
        for (int i = 0; i < rowFieldCount; ++i) {
            minValues.setField(i, stats[i].minValue());
            maxValues.setField(i, stats[i].maxValue());
            nullCounts[i] = stats[i].nullCount();
        }
        return new BinaryTableStats(this.serializer.toBinaryRow((InternalRow)minValues).copy(), this.serializer.toBinaryRow((InternalRow)maxValues).copy(), BinaryArray.fromLongArray((Long[])nullCounts));
    }

    public InternalRow evolution(BinaryRow values) {
        Object row = values;
        if (this.indexMapping != null) {
            row = ProjectedRow.from((int[])this.indexMapping).replaceRow((InternalRow)row);
        }
        if (this.castFieldGetters != null) {
            row = CastedRow.from(this.castFieldGetters).replaceRow((InternalRow)values);
        }
        return row;
    }

    public InternalArray evolution(BinaryArray nullCounts, @Nullable Long rowCount) {
        if (this.indexMapping == null) {
            return nullCounts;
        }
        if (rowCount == null) {
            throw new RuntimeException("Schema Evolution for stats needs row count.");
        }
        return new NullCountsEvoArray(this.indexMapping, (InternalArray)nullCounts, rowCount);
    }

    public static RowType schema() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "_MIN_VALUES", (DataType)SerializationUtils.newBytesType(false)));
        fields.add(new DataField(1, "_MAX_VALUES", (DataType)SerializationUtils.newBytesType(false)));
        fields.add(new DataField(2, "_NULL_COUNTS", (DataType)new ArrayType((DataType)new BigIntType(true))));
        return new RowType(fields);
    }

    private static RowType toAllFieldsNullableRowType(RowType rowType) {
        return RowType.builder().fields((DataType[])rowType.getFields().stream().map(f -> f.type().copy(true)).toArray(DataType[]::new), rowType.getFieldNames().toArray(new String[0])).build();
    }

    private static class NullCountsEvoArray
    implements InternalArray {
        private final int[] indexMapping;
        private final InternalArray array;
        private final long notFoundValue;

        protected NullCountsEvoArray(int[] indexMapping, InternalArray array, long notFoundValue) {
            this.indexMapping = indexMapping;
            this.array = array;
            this.notFoundValue = notFoundValue;
        }

        public int size() {
            return this.indexMapping.length;
        }

        public boolean isNullAt(int pos) {
            if (this.indexMapping[pos] < 0) {
                return false;
            }
            return this.array.isNullAt(this.indexMapping[pos]);
        }

        public long getLong(int pos) {
            if (this.indexMapping[pos] < 0) {
                return this.notFoundValue;
            }
            return this.array.getLong(this.indexMapping[pos]);
        }

        public boolean getBoolean(int pos) {
            throw new UnsupportedOperationException();
        }

        public byte getByte(int pos) {
            throw new UnsupportedOperationException();
        }

        public short getShort(int pos) {
            throw new UnsupportedOperationException();
        }

        public int getInt(int pos) {
            throw new UnsupportedOperationException();
        }

        public float getFloat(int pos) {
            throw new UnsupportedOperationException();
        }

        public double getDouble(int pos) {
            throw new UnsupportedOperationException();
        }

        public BinaryString getString(int pos) {
            throw new UnsupportedOperationException();
        }

        public Decimal getDecimal(int pos, int precision, int scale) {
            throw new UnsupportedOperationException();
        }

        public Timestamp getTimestamp(int pos, int precision) {
            throw new UnsupportedOperationException();
        }

        public byte[] getBinary(int pos) {
            throw new UnsupportedOperationException();
        }

        public InternalArray getArray(int pos) {
            throw new UnsupportedOperationException();
        }

        public InternalMap getMap(int pos) {
            throw new UnsupportedOperationException();
        }

        public InternalRow getRow(int pos, int numFields) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            throw new UnsupportedOperationException();
        }

        public boolean[] toBooleanArray() {
            throw new UnsupportedOperationException();
        }

        public byte[] toByteArray() {
            throw new UnsupportedOperationException();
        }

        public short[] toShortArray() {
            throw new UnsupportedOperationException();
        }

        public int[] toIntArray() {
            throw new UnsupportedOperationException();
        }

        public long[] toLongArray() {
            throw new UnsupportedOperationException();
        }

        public float[] toFloatArray() {
            throw new UnsupportedOperationException();
        }

        public double[] toDoubleArray() {
            throw new UnsupportedOperationException();
        }
    }
}

