/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation.metrics;

import java.util.LinkedList;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.utils.Preconditions;

@ThreadSafe
public class CompactTimer {
    private final long queryLengthMillis;
    private final LinkedList<TimeInterval> intervals;
    private long innerSum;
    private long lastCallMillis;

    public CompactTimer(long queryLengthMillis) {
        this.queryLengthMillis = queryLengthMillis;
        this.intervals = new LinkedList();
        this.innerSum = 0L;
        this.lastCallMillis = -1L;
    }

    public void start() {
        this.start(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void start(long millis) {
        LinkedList<TimeInterval> linkedList = this.intervals;
        synchronized (linkedList) {
            this.removeExpiredIntervals(millis - this.queryLengthMillis);
            Preconditions.checkArgument((this.intervals.isEmpty() || this.intervals.getLast().finished() ? 1 : 0) != 0, (Object)"There is an unfinished interval. This is unexpected.");
            Preconditions.checkArgument((this.lastCallMillis <= millis ? 1 : 0) != 0, (Object)"millis must not decrease.");
            this.lastCallMillis = millis;
            if (this.intervals.size() > 1) {
                this.innerSum += this.intervals.getLast().totalLength();
            }
            this.intervals.add(new TimeInterval(millis));
        }
    }

    public void finish() {
        this.finish(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void finish(long millis) {
        LinkedList<TimeInterval> linkedList = this.intervals;
        synchronized (linkedList) {
            this.removeExpiredIntervals(millis - this.queryLengthMillis);
            Preconditions.checkArgument((this.intervals.size() > 0 && !this.intervals.getLast().finished() ? 1 : 0) != 0, (Object)"There is no unfinished interval. This is unexpected.");
            Preconditions.checkArgument((this.lastCallMillis <= millis ? 1 : 0) != 0, (Object)"millis must not decrease.");
            this.lastCallMillis = millis;
            this.intervals.getLast().finish(millis);
        }
    }

    public long calculateLength() {
        return this.calculateLength(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    long calculateLength(long toMillis) {
        LinkedList<TimeInterval> linkedList = this.intervals;
        synchronized (linkedList) {
            Preconditions.checkArgument((this.lastCallMillis <= toMillis ? 1 : 0) != 0, (Object)"millis must not decrease.");
            this.lastCallMillis = toMillis;
            long fromMillis = toMillis - this.queryLengthMillis;
            this.removeExpiredIntervals(fromMillis);
            if (this.intervals.isEmpty()) {
                return 0L;
            }
            if (this.intervals.size() == 1) {
                return this.intervals.getFirst().calculateLength(fromMillis, toMillis);
            }
            return this.innerSum + this.intervals.getFirst().calculateLength(fromMillis, toMillis) + this.intervals.getLast().calculateLength(fromMillis, toMillis);
        }
    }

    private void removeExpiredIntervals(long expireMillis) {
        while (this.intervals.size() > 0 && this.intervals.getFirst().finished() && this.intervals.getFirst().finishMillis <= expireMillis) {
            this.intervals.removeFirst();
            if (this.intervals.size() <= 1) continue;
            this.innerSum -= this.intervals.getFirst().totalLength();
        }
    }

    private static class TimeInterval {
        private final long startMillis;
        private Long finishMillis;

        private TimeInterval(long startMillis) {
            this.startMillis = startMillis;
            this.finishMillis = null;
        }

        private void finish(long finishMillis) {
            this.finishMillis = finishMillis;
        }

        private boolean finished() {
            return this.finishMillis != null;
        }

        private long totalLength() {
            return this.finishMillis - this.startMillis;
        }

        private long calculateLength(long fromMillis, long toMillis) {
            if (this.finishMillis == null) {
                return toMillis - Math.min(Math.max(this.startMillis, fromMillis), toMillis);
            }
            long l = Math.max(fromMillis, this.startMillis);
            long r = Math.min(toMillis, this.finishMillis);
            return Math.max(0L, r - l);
        }
    }
}

