/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.types.RowKind;

public class ReverseReader
implements RecordReader<KeyValue> {
    private final RecordReader<KeyValue> reader;

    public ReverseReader(RecordReader<KeyValue> reader) {
        this.reader = reader;
    }

    @Nullable
    public RecordReader.RecordIterator<KeyValue> readBatch() throws IOException {
        final RecordReader.RecordIterator batch = this.reader.readBatch();
        if (batch == null) {
            return null;
        }
        return new RecordReader.RecordIterator<KeyValue>(){

            public KeyValue next() throws IOException {
                KeyValue kv = (KeyValue)batch.next();
                if (kv == null) {
                    return null;
                }
                if (kv.valueKind() == RowKind.UPDATE_BEFORE || kv.valueKind() == RowKind.DELETE) {
                    throw new IllegalStateException("In reverse reader, the value kind of records cannot be UPDATE_BEFORE or DELETE.");
                }
                return kv.replaceValueKind(RowKind.DELETE);
            }

            public void releaseBatch() {
                batch.releaseBatch();
            }
        };
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

