/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate;

import org.apache.paimon.data.BinaryString;
import org.apache.paimon.mergetree.compact.aggregate.FieldAggregator;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.StringUtils;

public class FieldListaggAgg
extends FieldAggregator {
    public static final String NAME = "listagg";
    public static final String DELIMITER = ",";

    public FieldListaggAgg(DataType dataType) {
        super(dataType);
    }

    @Override
    String name() {
        return NAME;
    }

    @Override
    public Object agg(Object accumulator, Object inputField) {
        Object concatenate;
        if (inputField == null || accumulator == null) {
            concatenate = inputField == null ? accumulator : inputField;
        } else {
            switch (this.fieldType.getTypeRoot()) {
                case VARCHAR: {
                    BinaryString mergeFieldSD = (BinaryString)accumulator;
                    BinaryString inFieldSD = (BinaryString)inputField;
                    concatenate = StringUtils.concat((BinaryString[])new BinaryString[]{mergeFieldSD, BinaryString.fromString((String)DELIMITER), inFieldSD});
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return concatenate;
    }
}

