/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.fileindex.FileIndexPredicate;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.TableSchema;

public class FileIndexSkipper {
    public static boolean skip(FileIO fileIO, TableSchema dataSchema, List<Predicate> dataFilter, DataFilePathFactory dataFilePathFactory, DataFileMeta file) throws IOException {
        List indexFiles;
        if (dataFilter != null && !dataFilter.isEmpty() && !(indexFiles = file.extraFiles().stream().filter(name -> name.endsWith(".index")).collect(Collectors.toList())).isEmpty()) {
            if (indexFiles.size() > 1) {
                throw new RuntimeException("Found more than one index file for one data file: " + String.join((CharSequence)" and ", indexFiles));
            }
            try (FileIndexPredicate predicate = new FileIndexPredicate(dataFilePathFactory.toPath((String)indexFiles.get(0)), fileIO, dataSchema.logicalRowType());){
                if (!predicate.testPredicate(PredicateBuilder.and((Predicate[])dataFilter.toArray(new Predicate[0])))) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }
}

