/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.disk;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.serializer.BinaryRowSerializer;
import org.apache.paimon.disk.ChannelReaderInputView;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.utils.MutableObjectIterator;

public class ChannelReaderInputViewIterator
implements MutableObjectIterator<BinaryRow> {
    private final ChannelReaderInputView inView;
    private final BinaryRowSerializer accessors;
    private final List<MemorySegment> freeMemTarget;

    public ChannelReaderInputViewIterator(ChannelReaderInputView inView, List<MemorySegment> freeMemTarget, BinaryRowSerializer accessors) {
        this.inView = inView;
        this.freeMemTarget = freeMemTarget;
        this.accessors = accessors;
    }

    @Override
    public BinaryRow next(BinaryRow reuse) throws IOException {
        try {
            return this.accessors.deserialize(reuse, (DataInputView)this.inView);
        }
        catch (EOFException eofex) {
            List<MemorySegment> freeMem = this.inView.close();
            if (this.freeMemTarget != null) {
                this.freeMemTarget.addAll(freeMem);
            }
            return null;
        }
    }

    @Override
    public BinaryRow next() throws IOException {
        try {
            return this.accessors.deserialize((DataInputView)this.inView);
        }
        catch (EOFException eofex) {
            List<MemorySegment> freeMem = this.inView.close();
            if (this.freeMemTarget != null) {
                this.freeMemTarget.addAll(freeMem);
            }
            return null;
        }
    }
}

