/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import java.util.TimeZone;
import java.util.function.Function;
import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.utils.DateTimeUtils;

class TimestampToTimestampCastRule
extends AbstractCastRule<Timestamp, Timestamp> {
    static final TimestampToTimestampCastRule INSTANCE = new TimestampToTimestampCastRule();

    private TimestampToTimestampCastRule() {
        super(CastRulePredicate.builder().input(DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).input(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).target(DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).target(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).build());
    }

    @Override
    public CastExecutor<Timestamp, Timestamp> create(DataType inputType, DataType targetType) {
        int inputPrecision = DataTypeChecks.getPrecision((DataType)inputType);
        int targetPrecision = DataTypeChecks.getPrecision((DataType)targetType);
        Function<Timestamp, Timestamp> operand = inputType.is(DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) && targetType.is(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE) ? value -> DateTimeUtils.timestampToTimestampWithLocalZone((Timestamp)value, (TimeZone)DateTimeUtils.LOCAL_TZ) : (inputType.is(DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE) && targetType.is(DataTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE) ? value -> DateTimeUtils.timestampWithLocalZoneToTimestamp((Timestamp)value, (TimeZone)DateTimeUtils.LOCAL_TZ) : value -> value);
        if (inputPrecision <= targetPrecision) {
            return operand::apply;
        }
        return value -> DateTimeUtils.truncate((Timestamp)((Timestamp)operand.apply((Timestamp)value)), (int)targetPrecision);
    }
}

