/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.casting;

import org.apache.paimon.casting.AbstractCastRule;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastRulePredicate;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.utils.BinaryStringUtils;

class BinaryToBinaryCastRule
extends AbstractCastRule<byte[], byte[]> {
    static final BinaryToBinaryCastRule INSTANCE = new BinaryToBinaryCastRule();

    private BinaryToBinaryCastRule() {
        super(CastRulePredicate.builder().input(DataTypeFamily.BINARY_STRING).target(DataTypeFamily.BINARY_STRING).build());
    }

    @Override
    public CastExecutor<byte[], byte[]> create(DataType inputType, DataType targetType) {
        return value -> BinaryStringUtils.toBinaryString((byte[])value, (DataType)targetType);
    }
}

