/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.outputs;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.gravitino.Audit;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.Metalake;
import org.apache.gravitino.Schema;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.outputs.BaseOutputFormat;
import org.apache.gravitino.cli.outputs.Column;
import org.apache.gravitino.cli.outputs.LineUtil;
import org.apache.gravitino.cli.outputs.OutputConstant;
import org.apache.gravitino.rel.Table;

public abstract class TableFormat<T>
extends BaseOutputFormat<T> {
    public static final int PADDING = 1;

    public static void output(Object entity, CommandContext context) {
        if (entity instanceof Metalake) {
            new MetalakeTableFormat(context).output((Metalake)entity);
        } else if (entity instanceof Metalake[]) {
            new MetalakeListTableFormat(context).output((Metalake[])entity);
        } else if (entity instanceof Catalog) {
            new CatalogTableFormat(context).output((Catalog)entity);
        } else if (entity instanceof Catalog[]) {
            new CatalogListTableFormat(context).output((Catalog[])entity);
        } else if (entity instanceof Schema) {
            new SchemaTableFormat(context).output((Schema)entity);
        } else if (entity instanceof Schema[]) {
            new SchemaListTableFormat(context).output((Schema[])entity);
        } else if (entity instanceof Table) {
            new TableDetailsTableFormat(context).output((Table)entity);
        } else if (entity instanceof Table[]) {
            new TableListTableFormat(context).output((Table[])entity);
        } else if (entity instanceof Audit) {
            new AuditTableFormat(context).output((Audit)entity);
        } else if (entity instanceof org.apache.gravitino.rel.Column[]) {
            new ColumnListTableFormat(context).output((org.apache.gravitino.rel.Column[])entity);
        } else {
            throw new IllegalArgumentException("Unsupported object type");
        }
    }

    public TableFormat(CommandContext context) {
        super(context);
    }

    public String getTableFormat(Column ... columns) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String[] headers = (String[])Arrays.stream(columns).map(Column::getHeader).filter(Objects::nonNull).toArray(String[]::new);
        ImmutableList<Character> borders = OutputConstant.BASIC_ASCII;
        if (headers.length != columns.length) {
            throw new IllegalArgumentException("Headers must be provided for all columns");
        }
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);){
            TableFormat.writeUpperBorder(osw, borders, System.lineSeparator(), columns);
            TableFormat.writeHeader(osw, borders, System.lineSeparator(), columns);
            TableFormat.writeHeaderBorder(osw, borders, System.lineSeparator(), columns);
            this.writeData(osw, borders, columns, System.lineSeparator());
            TableFormat.writeBottomBorder(osw, borders, System.lineSeparator(), columns);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    private static void writeUpperBorder(OutputStreamWriter writer, List<Character> borders, String lineSeparator, Column[] columns) throws IOException {
        TableFormat.writeHorizontalLine(writer, borders.get(0), borders.get(1), borders.get(2), borders.get(3), lineSeparator, columns);
    }

    private static void writeHeaderBorder(OutputStreamWriter writer, List<Character> borders, String lineSeparator, Column[] columns) throws IOException {
        TableFormat.writeHorizontalLine(writer, borders.get(18), borders.get(19), borders.get(20), borders.get(21), lineSeparator, columns);
    }

    private static void writeRowSeparator(OutputStreamWriter writer, List<Character> borders, String lineSeparator, Column[] columns) throws IOException {
        TableFormat.writeHorizontalLine(writer, borders.get(14), borders.get(15), borders.get(16), borders.get(17), lineSeparator, columns);
    }

    private static void writeBottomBorder(OutputStreamWriter writer, List<Character> borders, String lineSeparator, Column[] columns) throws IOException {
        TableFormat.writeHorizontalLine(writer, borders.get(25), borders.get(26), borders.get(27), borders.get(28), lineSeparator, columns);
    }

    private void writeData(OutputStreamWriter writer, List<Character> borders, Column[] columns, String lineSeparator) throws IOException {
        int dataSize = columns[0].getCellCount();
        Column.HorizontalAlign[] dataAligns = (Column.HorizontalAlign[])Arrays.stream(columns).map(Column::getDataAlign).toArray(Column.HorizontalAlign[]::new);
        for (int i = 0; i < dataSize; ++i) {
            String[] data = TableFormat.getData(columns, i);
            TableFormat.writeRow(writer, borders.get(4), borders.get(5), borders.get(6), data, columns, dataAligns, lineSeparator);
        }
    }

    private static void writeHorizontalLine(OutputStreamWriter osw, Character left, Character middle, Character columnSeparator, Character right, String lineSeparator, Column[] columns) throws IOException {
        Integer[] colWidths = (Integer[])Arrays.stream(columns).map(s2 -> s2.getMaxWidth() + 2).toArray(Integer[]::new);
        if (left != null) {
            osw.write(left.charValue());
        }
        for (int col = 0; col < colWidths.length; ++col) {
            TableFormat.writeRepeated(osw, middle.charValue(), colWidths[col]);
            if (columnSeparator == null || col == colWidths.length - 1) continue;
            osw.write(columnSeparator.charValue());
        }
        if (right != null) {
            osw.write(right.charValue());
        }
        if (lineSeparator != null) {
            osw.write(System.lineSeparator());
        }
    }

    private static void writeHeader(OutputStreamWriter osw, List<Character> borders, String lineSeparator, Column[] columns) throws IOException {
        Column.HorizontalAlign[] dataAligns = (Column.HorizontalAlign[])Arrays.stream(columns).map(Column::getHeaderAlign).toArray(Column.HorizontalAlign[]::new);
        String[] headers = (String[])Arrays.stream(columns).map(Column::getHeader).filter(Objects::nonNull).toArray(String[]::new);
        TableFormat.writeRow(osw, borders.get(4), borders.get(5), borders.get(6), headers, columns, dataAligns, lineSeparator);
    }

    private static void writeRow(OutputStreamWriter osw, Character left, Character columnSeparator, Character right, String[] data, Column[] columns, Column.HorizontalAlign[] dataAligns, String lineSeparator) throws IOException {
        if (left != null) {
            osw.write(left.charValue());
        }
        for (int i = 0; i < data.length; ++i) {
            int maxWidth = columns[i].getMaxWidth();
            Column.HorizontalAlign dataAlign = dataAligns[i];
            TableFormat.writeJustified(osw, data[i], dataAlign, maxWidth, 1);
            if (i >= data.length - 1) continue;
            osw.write(columnSeparator.charValue());
        }
        if (right != null) {
            osw.write(right.charValue());
        }
        osw.write(lineSeparator);
    }

    private static String[] getData(Column[] columns, int rowIndex) {
        return (String[])Arrays.stream(columns).map(c -> c.getCell(rowIndex)).toArray(String[]::new);
    }

    private static void writeJustified(OutputStreamWriter osw, String str, Column.HorizontalAlign align, int maxLength, int minPadding) throws IOException {
        osw.write(LineUtil.getSpaces(minPadding));
        if (str.length() < maxLength) {
            int leftPadding = align == Column.HorizontalAlign.LEFT ? 0 : (align == Column.HorizontalAlign.CENTER ? (maxLength - LineUtil.getDisplayWidth(str)) / 2 : maxLength - LineUtil.getDisplayWidth(str));
            TableFormat.writeRepeated(osw, ' ', leftPadding);
            osw.write(str);
            TableFormat.writeRepeated(osw, ' ', maxLength - LineUtil.getDisplayWidth(str) - leftPadding);
        } else {
            osw.write(str);
        }
        osw.write(LineUtil.getSpaces(minPadding));
    }

    private static void writeRepeated(OutputStreamWriter osw, char c, int num) throws IOException {
        for (int i = 0; i < num; ++i) {
            osw.append(c);
        }
    }

    static final class ColumnListTableFormat
    extends TableFormat<org.apache.gravitino.rel.Column[]> {
        public ColumnListTableFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(org.apache.gravitino.rel.Column[] columns) {
            Column columnName = new Column(this.context, "name");
            Column columnType = new Column(this.context, "type");
            Column columnDefaultVal = new Column(this.context, "default");
            Column columnAutoIncrement = new Column(this.context, "AutoIncrement");
            Column columnNullable = new Column(this.context, "nullable");
            Column columnComment = new Column(this.context, "comment");
            for (org.apache.gravitino.rel.Column column : columns) {
                columnName.addCell(column.name());
                columnType.addCell(column.dataType().simpleString());
                columnDefaultVal.addCell(LineUtil.getDefaultValue(column));
                columnAutoIncrement.addCell(LineUtil.getAutoIncrement(column));
                columnNullable.addCell(column.nullable());
                columnComment.addCell(LineUtil.getComment(column));
            }
            return this.getTableFormat(columnName, columnType, columnDefaultVal, columnAutoIncrement, columnNullable, columnComment);
        }
    }

    static final class AuditTableFormat
    extends TableFormat<Audit> {
        public AuditTableFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Audit audit) {
            Column columnCreator = new Column(this.context, "creator");
            Column columnCreateTime = new Column(this.context, "creation at");
            Column columnModified = new Column(this.context, "modifier");
            Column columnModifyTime = new Column(this.context, "modified at");
            columnCreator.addCell(audit.creator());
            columnCreateTime.addCell(audit.createTime() == null ? "N/A" : audit.createTime().toString());
            columnModified.addCell(audit.lastModifier() == null ? "N/A" : audit.lastModifier());
            columnModifyTime.addCell(audit.lastModifiedTime() == null ? "N/A" : audit.lastModifiedTime().toString());
            return this.getTableFormat(columnCreator, columnCreateTime, columnModified, columnModifyTime);
        }
    }

    static final class TableListTableFormat
    extends TableFormat<Table[]> {
        public TableListTableFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Table[] tables) {
            Column column = new Column(this.context, "table");
            Arrays.stream(tables).forEach(table -> column.addCell(table.name()));
            return this.getTableFormat(column);
        }
    }

    static final class TableDetailsTableFormat
    extends TableFormat<Table> {
        public TableDetailsTableFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Table table) {
            org.apache.gravitino.rel.Column[] columns;
            Column columnName = new Column(this.context, "name");
            Column columnType = new Column(this.context, "type");
            Column columnDefaultValue = new Column(this.context, "default");
            Column columnAutoIncrement = new Column(this.context, "AutoIncrement");
            Column columnNullable = new Column(this.context, "nullable");
            Column columnComment = new Column(this.context, "comment");
            for (org.apache.gravitino.rel.Column column : columns = table.columns()) {
                columnName.addCell(column.name());
                columnType.addCell(column.dataType().simpleString());
                columnDefaultValue.addCell(LineUtil.getDefaultValue(column));
                columnAutoIncrement.addCell(LineUtil.getAutoIncrement(column));
                columnNullable.addCell(column.nullable());
                columnComment.addCell(column.comment() == null || column.comment().isEmpty() ? "N/A" : column.comment());
            }
            return this.getTableFormat(columnName, columnType, columnDefaultValue, columnAutoIncrement, columnNullable, columnComment);
        }
    }

    static final class SchemaListTableFormat
    extends TableFormat<Schema[]> {
        public SchemaListTableFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Schema[] schemas) {
            Column column = new Column(this.context, "schema");
            Arrays.stream(schemas).forEach(schema -> column.addCell(schema.name()));
            return this.getTableFormat(column);
        }
    }

    static final class SchemaTableFormat
    extends TableFormat<Schema> {
        public SchemaTableFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Schema schema) {
            Column columnName = new Column(this.context, "schema");
            Column columnComment = new Column(this.context, "comment");
            columnName.addCell(schema.name());
            columnComment.addCell(schema.comment());
            return this.getTableFormat(columnName, columnComment);
        }
    }

    static final class CatalogListTableFormat
    extends TableFormat<Catalog[]> {
        public CatalogListTableFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Catalog[] catalogs) {
            Column columnName = new Column(this.context, "catalog");
            Arrays.stream(catalogs).forEach(metalake -> columnName.addCell(metalake.name()));
            return this.getTableFormat(columnName);
        }
    }

    static final class CatalogTableFormat
    extends TableFormat<Catalog> {
        public CatalogTableFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Catalog catalog) {
            Column columnName = new Column(this.context, "catalog");
            Column columnType = new Column(this.context, "type");
            Column columnProvider = new Column(this.context, "provider");
            Column columnComment = new Column(this.context, "comment");
            columnName.addCell(catalog.name());
            columnType.addCell(catalog.type().name());
            columnProvider.addCell(catalog.provider());
            columnComment.addCell(catalog.comment());
            return this.getTableFormat(columnName, columnType, columnProvider, columnComment);
        }
    }

    static final class MetalakeListTableFormat
    extends TableFormat<Metalake[]> {
        public MetalakeListTableFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Metalake[] metalakes) {
            Column columnName = new Column(this.context, "metalake");
            Arrays.stream(metalakes).forEach(metalake -> columnName.addCell(metalake.name()));
            return this.getTableFormat(columnName);
        }
    }

    static final class MetalakeTableFormat
    extends TableFormat<Metalake> {
        public MetalakeTableFormat(CommandContext context) {
            super(context);
        }

        @Override
        public String getOutput(Metalake metalake) {
            Column columnName = new Column(this.context, "metalake");
            Column columnComment = new Column(this.context, "comment");
            columnName.addCell(metalake.name());
            columnComment.addCell(metalake.comment());
            return this.getTableFormat(columnName, columnComment);
        }
    }
}

