/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.Audit;
import org.apache.gravitino.Schema;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;

public class ListSchema
extends Command {
    protected final String metalake;
    protected final String catalog;

    public ListSchema(CommandContext context, String metalake, String catalog) {
        super(context);
        this.metalake = metalake;
        this.catalog = catalog;
    }

    @Override
    public void handle() {
        String[] schemas = new String[]{};
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            schemas = client.loadCatalog(this.catalog).asSchemas().listSchemas();
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (schemas.length == 0) {
            this.printInformation("No schemas exist.");
            return;
        }
        Schema[] schemaObjects = new Schema[schemas.length];
        for (int i = 0; i < schemas.length; ++i) {
            Schema gSchema;
            final String schemaName = schemas[i];
            schemaObjects[i] = gSchema = new Schema(){

                @Override
                public String name() {
                    return schemaName;
                }

                @Override
                public Audit auditInfo() {
                    return null;
                }
            };
        }
        this.printResults(schemaObjects);
    }
}

