/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.Catalog;
import org.apache.gravitino.Schema;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.cli.utils.FullNameUtil;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.messaging.Topic;
import org.apache.gravitino.model.Model;
import org.apache.gravitino.rel.Table;

public class ListEntityTags
extends Command {
    protected String metalake;
    protected FullName name;

    public ListEntityTags(CommandContext context, String metalake, FullName name) {
        super(context);
        this.metalake = metalake;
        this.name = name;
    }

    @Override
    public void handle() {
        CharSequence[] tags = new String[]{};
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            if (this.name.getLevel() == 3) {
                String catalog = this.name.getCatalogName();
                Catalog catalogObject = client.loadCatalog(catalog);
                switch (catalogObject.type()) {
                    case RELATIONAL: {
                        Table gTable = catalogObject.asTableCatalog().loadTable(FullNameUtil.toTable(this.name));
                        tags = gTable.supportsTags().listTags();
                        break;
                    }
                    case MODEL: {
                        Model gModel = catalogObject.asModelCatalog().getModel(FullNameUtil.toModel(this.name));
                        tags = gModel.supportsTags().listTags();
                        break;
                    }
                    case FILESET: {
                        Fileset fileset = catalogObject.asFilesetCatalog().loadFileset(FullNameUtil.toFileset(this.name));
                        tags = fileset.supportsTags().listTags();
                        break;
                    }
                    case MESSAGING: {
                        Topic topic = catalogObject.asTopicCatalog().loadTopic(FullNameUtil.toTopic(this.name));
                        tags = topic.supportsTags().listTags();
                        break;
                    }
                }
            } else if (this.name.hasSchemaName()) {
                String catalog = this.name.getCatalogName();
                String schema = this.name.getSchemaName();
                Schema gSchema = client.loadCatalog(catalog).asSchemas().loadSchema(schema);
                tags = gSchema.supportsTags().listTags();
            } else if (this.name.hasCatalogName()) {
                String catalog = this.name.getCatalogName();
                Catalog gCatalog = client.loadCatalog(catalog);
                tags = gCatalog.supportsTags().listTags();
            }
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchTableException err) {
            this.exitWithError("Unknown table name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        String all = String.join((CharSequence)",", tags);
        this.printResults(all);
    }
}

