/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.AreYouSure;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;

public class DeleteTable
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String table;
    protected final boolean force;

    public DeleteTable(CommandContext context, String metalake, String catalog, String schema, String table) {
        super(context);
        this.force = context.force();
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.table = table;
    }

    @Override
    public void handle() {
        boolean deleted = false;
        if (!AreYouSure.really(this.force)) {
            return;
        }
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            NameIdentifier name = NameIdentifier.of(this.schema, this.table);
            deleted = client.loadCatalog(this.catalog).asTableCatalog().dropTable(name);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchTableException err) {
            this.exitWithError("Unknown table name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (deleted) {
            this.printInformation(this.table + " deleted.");
        } else {
            this.printInformation(this.table + " not deleted.");
        }
    }
}

