/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.TagAlreadyExistsException;

public class CreateTag
extends Command {
    protected final String metalake;
    protected final String[] tags;
    protected final String comment;

    public CreateTag(CommandContext context, String metalake, String[] tags, String comment) {
        super(context);
        this.metalake = metalake;
        this.tags = tags;
        this.comment = comment;
    }

    @Override
    public void handle() {
        if (this.tags == null || this.tags.length == 0) {
            System.err.println("Missing --tag option.");
        } else {
            boolean hasOnlyOneTag;
            boolean bl = hasOnlyOneTag = this.tags.length == 1;
            if (hasOnlyOneTag) {
                this.handleOnlyOneTag();
            } else {
                this.handleMultipleTags();
            }
        }
    }

    private void handleOnlyOneTag() {
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            client.createTag(this.tags[0], this.comment, null);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (TagAlreadyExistsException err) {
            this.exitWithError("Tag already exists.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation("Tag " + this.tags[0] + " created");
    }

    private void handleMultipleTags() {
        ArrayList<String> created = new ArrayList<String>();
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            for (String tag : this.tags) {
                client.createTag(tag, this.comment, null);
                created.add(tag);
            }
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (TagAlreadyExistsException err) {
            this.exitWithError("Tag already exists.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (!created.isEmpty()) {
            this.printInformation("Tags " + String.join((CharSequence)",", created) + " created");
        }
        if (created.size() < this.tags.length) {
            List<String> remaining = Arrays.asList(this.tags);
            remaining.removeAll(created);
            this.printInformation("Tags " + String.join((CharSequence)",", remaining) + " not created");
        }
    }

    @Override
    public Command validate() {
        if (this.tags == null) {
            this.exitWithError("Missing --tag option.");
        }
        return super.validate();
    }
}

