/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import java.util.HashSet;
import org.apache.gravitino.Catalog;

public class Providers {
    public static final String HIVE = "hive";
    public static final String HADOOP = "hadoop";
    public static final String ICEBERG = "iceberg";
    public static final String MYSQL = "mysql";
    public static final String POSTGRES = "postgres";
    public static final String KAFKA = "kafka";
    public static final String DORIS = "doris";
    public static final String PAIMON = "paimon";
    public static final String HUDI = "hudi";
    public static final String OCEANBASE = "oceanbase";
    private static final HashSet<String> VALID_PROVIDERS = new HashSet();

    public static boolean isValidProvider(String provider) {
        return VALID_PROVIDERS.contains(provider);
    }

    public static String internal(String provider) {
        switch (provider) {
            case "hive": {
                return HIVE;
            }
            case "hadoop": {
                return HADOOP;
            }
            case "mysql": {
                return "jdbc-mysql";
            }
            case "postgres": {
                return "jdbc-postgresql";
            }
            case "iceberg": {
                return "lakehouse-iceberg";
            }
            case "kafka": {
                return KAFKA;
            }
            case "doris": {
                return "jdbc-doris";
            }
            case "paimon": {
                return "lakehouse-paimon";
            }
            case "hudi": {
                return "lakehouse-hudi";
            }
            case "oceanbase": {
                return "jdbc-oceanbase";
            }
        }
        throw new IllegalArgumentException("Unsupported provider: " + provider);
    }

    public static Catalog.Type catalogType(String provider) {
        switch (provider) {
            case "hadoop": {
                return Catalog.Type.FILESET;
            }
            case "hive": 
            case "mysql": 
            case "postgres": 
            case "iceberg": 
            case "doris": 
            case "paimon": 
            case "hudi": 
            case "oceanbase": {
                return Catalog.Type.RELATIONAL;
            }
            case "kafka": {
                return Catalog.Type.MESSAGING;
            }
        }
        throw new IllegalArgumentException("Unsupported provider: " + provider);
    }

    static {
        VALID_PROVIDERS.add(HIVE);
        VALID_PROVIDERS.add(HADOOP);
        VALID_PROVIDERS.add(ICEBERG);
        VALID_PROVIDERS.add(MYSQL);
        VALID_PROVIDERS.add(POSTGRES);
        VALID_PROVIDERS.add(KAFKA);
        VALID_PROVIDERS.add(DORIS);
        VALID_PROVIDERS.add(PAIMON);
        VALID_PROVIDERS.add(HUDI);
        VALID_PROVIDERS.add(OCEANBASE);
    }
}

