/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.AuthorizationMetadataObject;

public class PathBasedMetadataObject
implements AuthorizationMetadataObject {
    public static final PathType METALAKE_PATH = new PathType(MetadataObject.Type.METALAKE);
    public static final PathType CATALOG_PATH = new PathType(MetadataObject.Type.CATALOG);
    public static final PathType SCHEMA_PATH = new PathType(MetadataObject.Type.SCHEMA);
    public static final PathType TABLE_PATH = new PathType(MetadataObject.Type.TABLE);
    public static final PathType FILESET_PATH = new PathType(MetadataObject.Type.FILESET);
    private final String name;
    private final String parent;
    private final String path;
    private final boolean recursive;
    private final AuthorizationMetadataObject.Type type;

    public PathBasedMetadataObject(String parent, String name, String path, AuthorizationMetadataObject.Type type) {
        this(parent, name, path, type, true);
    }

    public PathBasedMetadataObject(String parent, String name, String path, AuthorizationMetadataObject.Type type, boolean recursive) {
        this.parent = parent;
        this.name = name;
        this.path = path;
        this.type = type;
        this.recursive = recursive;
    }

    public String name() {
        return this.name;
    }

    public List<String> names() {
        return DOT_SPLITTER.splitToList((CharSequence)this.fullName());
    }

    public String parent() {
        return this.parent;
    }

    public String path() {
        return this.path;
    }

    public boolean recursive() {
        return this.recursive;
    }

    public AuthorizationMetadataObject.Type type() {
        return this.type;
    }

    public void validateAuthorizationMetadataObject() throws IllegalArgumentException {
        List<String> names = this.names();
        Preconditions.checkArgument((names != null && !names.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create a path based metadata object with no names");
        Preconditions.checkArgument((this.path != null && !this.path.isEmpty() ? 1 : 0) != 0, (Object)"Cannot create a path based metadata object with no path");
        Preconditions.checkArgument((boolean)(this.type instanceof PathType), (Object)"it must be the PATH type");
        for (String name : names) {
            Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Cannot create a path based metadata object with null name");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathBasedMetadataObject)) {
            return false;
        }
        PathBasedMetadataObject that = (PathBasedMetadataObject)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.parent, that.parent) && Objects.equals(this.path, that.path) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parent, this.path, this.type);
    }

    public String toString() {
        String strPath = this.path == null ? "null" : this.path;
        return "MetadataObject: [fullName=" + this.fullName() + "],  [path=" + strPath + "], [type=" + this.type + "]";
    }

    public static final class PathType
    implements AuthorizationMetadataObject.Type {
        private static final Set<MetadataObject.Type> allowObjectTypes = ImmutableSet.of((Object)MetadataObject.Type.METALAKE, (Object)MetadataObject.Type.CATALOG, (Object)MetadataObject.Type.SCHEMA, (Object)MetadataObject.Type.TABLE, (Object)MetadataObject.Type.FILESET);
        private final MetadataObject.Type metadataType;

        public static PathType get(MetadataObject.Type type) {
            return new PathType(type);
        }

        private PathType(MetadataObject.Type type) {
            Preconditions.checkArgument((boolean)allowObjectTypes.contains(type), (Object)"The type isn't allow to create path type");
            this.metadataType = type;
        }

        public MetadataObject.Type metadataObjectType() {
            return this.metadataType;
        }

        public int hashCode() {
            return this.metadataType.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PathType)) {
                return false;
            }
            return this.metadataType.equals((Object)((PathType)obj).metadataType);
        }

        public String toString() {
            return "PATH";
        }
    }
}

