/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.Field;

public interface Entity
extends Serializable {
    public static final String SYSTEM_METALAKE_RESERVED_NAME = "system";
    public static final String SYSTEM_CATALOG_RESERVED_NAME = "system";
    public static final String AUTHORIZATION_CATALOG_NAME = "authorization";
    public static final String USER_SCHEMA_NAME = "user";
    public static final String GROUP_SCHEMA_NAME = "group";
    public static final String ROLE_SCHEMA_NAME = "role";
    public static final String ADMIN_SCHEMA_NAME = "admin";
    public static final String TAG_SCHEMA_NAME = "tag";

    default public void validate() throws IllegalArgumentException {
        this.fields().forEach(Field::validate);
    }

    public Map<Field, Object> fields();

    public EntityType type();

    public static enum EntityType {
        METALAKE("ml", 0),
        CATALOG("ca", 1),
        SCHEMA("sc", 2),
        TABLE("ta", 3),
        COLUMN("co", 4),
        FILESET("fi", 5),
        TOPIC("to", 6),
        USER("us", 7),
        GROUP("gr", 8),
        ROLE("ro", 9),
        TAG("ta", 10),
        MODEL("mo", 11),
        MODEL_VERSION("mv", 12),
        AUDIT("au", 65534);

        private final String shortName;
        private final int index;

        private EntityType(String shortName, int index) {
            this.shortName = shortName;
            this.index = index;
        }

        public static EntityType fromShortName(String shortName) {
            for (EntityType entityType : EntityType.values()) {
                if (!entityType.shortName.equals(shortName)) continue;
                return entityType;
            }
            throw new IllegalArgumentException("Unknown entity type: " + shortName);
        }

        public static List<EntityType> getParentEntityTypes(EntityType entityType) {
            switch (entityType) {
                case METALAKE: {
                    return ImmutableList.of();
                }
                case CATALOG: {
                    return ImmutableList.of((Object)((Object)METALAKE));
                }
                case SCHEMA: {
                    return ImmutableList.of((Object)((Object)METALAKE), (Object)((Object)CATALOG));
                }
                case TABLE: 
                case FILESET: 
                case TOPIC: 
                case MODEL: 
                case USER: 
                case GROUP: 
                case ROLE: {
                    return ImmutableList.of((Object)((Object)METALAKE), (Object)((Object)CATALOG), (Object)((Object)SCHEMA));
                }
                case COLUMN: {
                    return ImmutableList.of((Object)((Object)METALAKE), (Object)((Object)CATALOG), (Object)((Object)SCHEMA), (Object)((Object)TABLE));
                }
                case MODEL_VERSION: {
                    return ImmutableList.of((Object)((Object)METALAKE), (Object)((Object)CATALOG), (Object)((Object)SCHEMA), (Object)((Object)MODEL));
                }
            }
            throw new IllegalArgumentException("Unknown entity type: " + (Object)((Object)entityType));
        }

        public String getShortName() {
            return this.shortName;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

