/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.paimon.authentication.kerberos;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.commons.io.FileUtils;

public class FetchFileUtils {
    private FetchFileUtils() {
    }

    public static void fetchFileFromUri(String fileUri, File destFile, int timeout) throws IOException {
        try {
            String scheme;
            URI uri = new URI(fileUri);
            switch (scheme = Optional.ofNullable(uri.getScheme()).orElse("file")) {
                case "http": 
                case "https": 
                case "ftp": {
                    FileUtils.copyURLToFile((URL)uri.toURL(), (File)destFile, (int)(timeout * 1000), (int)(timeout * 1000));
                    break;
                }
                case "file": {
                    Files.createSymbolicLink(destFile.toPath(), new File(uri.getPath()).toPath(), new FileAttribute[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Doesn't support the scheme %s", scheme));
                }
            }
        }
        catch (URISyntaxException ue) {
            throw new IllegalArgumentException("The uri of file has the wrong format", ue);
        }
    }
}

