/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.paimon;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.gravitino.catalog.lakehouse.paimon.GravitinoPaimonColumn;
import org.apache.gravitino.connector.BaseTable;
import org.apache.gravitino.connector.TableOperations;
import org.apache.gravitino.dto.rel.partitioning.Partitioning;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.indexes.Indexes;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.table.Table;
import org.apache.paimon.types.DataField;

public class GravitinoPaimonTable
extends BaseTable {
    @VisibleForTesting
    public static final String PAIMON_PRIMARY_KEY_INDEX_NAME = "PAIMON_PRIMARY_KEY_INDEX";

    private GravitinoPaimonTable() {
    }

    protected TableOperations newOps() {
        throw new UnsupportedOperationException("PaimonTable does not support TableOperations.");
    }

    public Schema toPaimonTableSchema() {
        Schema.Builder builder = Schema.newBuilder().comment(this.comment);
        if (this.properties == null) {
            this.properties = Maps.newHashMap();
        }
        if (this.partitioning == null) {
            this.partitioning = Partitioning.EMPTY_PARTITIONING;
        }
        HashMap normalizedProperties = new HashMap(this.properties);
        normalizedProperties.remove("comment");
        List<String> partitionKeys = GravitinoPaimonTable.getPartitionKeys(this.partitioning);
        List<String> primaryKeys = this.getPrimaryKeysFromIndexes(this.indexes);
        GravitinoPaimonTable.validate(primaryKeys, partitionKeys);
        builder.options(normalizedProperties).primaryKey(primaryKeys).partitionKeys(partitionKeys);
        for (int index = 0; index < this.columns.length; ++index) {
            DataField dataField = GravitinoPaimonColumn.toPaimonColumn(index, this.columns[index]);
            builder.column(dataField.name(), dataField.type(), dataField.description());
        }
        return builder.build();
    }

    public static GravitinoPaimonTable fromPaimonTable(Table table) {
        return (GravitinoPaimonTable)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)GravitinoPaimonTable.builder().withName(table.name())).withColumns((Column[])GravitinoPaimonColumn.fromPaimonRowType(table.rowType()).toArray(new GravitinoPaimonColumn[0]))).withPartitioning(GravitinoPaimonTable.toGravitinoPartitioning(table.partitionKeys()))).withComment(table.comment().orElse(null))).withProperties(table.options())).withIndexes(GravitinoPaimonTable.constructIndexesFromPrimaryKeys(table))).withAuditInfo(AuditInfo.EMPTY)).build();
    }

    public static Transform[] toGravitinoPartitioning(List<String> partitionKeys) {
        return (Transform[])partitionKeys.stream().map(Transforms::identity).toArray(Transform[]::new);
    }

    private static List<String> getPartitionKeys(Transform[] partitioning) {
        if (partitioning == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(partitioning).map(partition -> {
            NamedReference[] references = partition.references();
            Preconditions.checkArgument((references.length == 1 ? 1 : 0) != 0, (Object)"Partitioning column must be single-column, like 'a'.");
            return references[0].toString();
        }).collect(Collectors.toList());
    }

    private List<String> getPrimaryKeysFromIndexes(Index[] indexes) {
        if (indexes == null || indexes.length == 0) {
            return Collections.emptyList();
        }
        Preconditions.checkArgument((indexes.length == 1 ? 1 : 0) != 0, (Object)"Paimon only supports no more than one Index.");
        Index primaryKeyIndex = indexes[0];
        Arrays.stream(primaryKeyIndex.fieldNames()).forEach(filedName -> Preconditions.checkArgument((filedName != null && ((String[])filedName).length == 1 ? 1 : 0) != 0, (Object)"The primary key columns should not be nested."));
        return Arrays.stream(primaryKeyIndex.fieldNames()).map(fieldName -> fieldName[0]).collect(Collectors.toList());
    }

    private static Index[] constructIndexesFromPrimaryKeys(Table table) {
        Index[] indexes = new Index[]{};
        if (table.primaryKeys() != null && !table.primaryKeys().isEmpty()) {
            String[][] filedNames = GravitinoPaimonTable.constructIndexFiledNames(table.primaryKeys());
            indexes = Collections.singletonList(Indexes.primary((String)PAIMON_PRIMARY_KEY_INDEX_NAME, (String[][])filedNames)).toArray(new Index[0]);
        }
        return indexes;
    }

    /*
     * Exception decompiling
     */
    private static String[][] constructIndexFiledNames(List<String> primaryKeys) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void validate(List<String> primaryKeys, List<String> partitionKeys) {
        if (!primaryKeys.isEmpty()) {
            List adjusted = primaryKeys.stream().filter(pk -> !partitionKeys.contains(pk)).collect(Collectors.toList());
            Preconditions.checkState((!adjusted.isEmpty() ? 1 : 0) != 0, (Object)String.format("Paimon Table Primary key constraint %s should not be same with partition fields %s, this will result in only one record in a partition.", primaryKeys, partitionKeys));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "GravitinoPaimonTable()";
    }

    static /* synthetic */ Column[] access$302(GravitinoPaimonTable x0, Column[] x1) {
        x0.columns = x1;
        return x1;
    }

    static /* synthetic */ Transform[] access$402(GravitinoPaimonTable x0, Transform[] x1) {
        x0.partitioning = x1;
        return x1;
    }

    static /* synthetic */ Index[] access$602(GravitinoPaimonTable x0, Index[] x1) {
        x0.indexes = x1;
        return x1;
    }

    public static class Builder
    extends BaseTable.BaseTableBuilder<Builder, GravitinoPaimonTable> {
        private Builder() {
        }

        protected GravitinoPaimonTable internalBuild() {
            GravitinoPaimonTable paimonTable = new GravitinoPaimonTable();
            paimonTable.name = this.name;
            paimonTable.comment = this.comment;
            GravitinoPaimonTable.access$302(paimonTable, this.columns);
            GravitinoPaimonTable.access$402(paimonTable, this.partitioning);
            paimonTable.properties = this.properties == null ? Maps.newHashMap() : Maps.newHashMap((Map)this.properties);
            GravitinoPaimonTable.access$602(paimonTable, this.indexes);
            paimonTable.auditInfo = this.auditInfo;
            return paimonTable;
        }
    }
}

