/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.PropertiesMetadataHelpers;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.PropertiesMetadata;
import org.apache.gravitino.connector.capability.Capability;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.file.FilesetChange;
import org.apache.gravitino.messaging.TopicChange;
import org.apache.gravitino.rel.SupportsPartitions;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.ThrowableFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OperationDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(OperationDispatcher.class);
    private final CatalogManager catalogManager;
    protected final EntityStore store;
    protected final IdGenerator idGenerator;

    public OperationDispatcher(CatalogManager catalogManager, EntityStore store, IdGenerator idGenerator) {
        this.catalogManager = catalogManager;
        this.store = store;
        this.idGenerator = idGenerator;
    }

    protected <R, E extends Throwable> R doWithTable(NameIdentifier tableIdent, ThrowableFunction<SupportsPartitions, R> fn, Class<E> ex) throws E {
        try {
            NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(tableIdent);
            CatalogManager.CatalogWrapper c = this.catalogManager.loadCatalogAndWrap(catalogIdent);
            return c.doWithPartitionOps(tableIdent, fn);
        }
        catch (Throwable throwable) {
            if (ex.isInstance(throwable)) {
                throw (Throwable)ex.cast(throwable);
            }
            if (RuntimeException.class.isAssignableFrom(throwable.getClass())) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    protected <R, E extends Throwable> R doWithCatalog(NameIdentifier ident, ThrowableFunction<CatalogManager.CatalogWrapper, R> fn, Class<E> ex) throws E {
        CatalogManager.checkCatalogInUse(this.store, ident);
        try {
            CatalogManager.CatalogWrapper c = this.catalogManager.loadCatalogAndWrap(ident);
            return fn.apply(c);
        }
        catch (Throwable throwable) {
            if (ex.isInstance(throwable)) {
                throw (Throwable)ex.cast(throwable);
            }
            if (RuntimeException.class.isAssignableFrom(throwable.getClass())) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    protected <R, E1 extends Throwable, E2 extends Throwable> R doWithCatalog(NameIdentifier ident, ThrowableFunction<CatalogManager.CatalogWrapper, R> fn, Class<E1> ex1, Class<E2> ex2) throws E1, E2 {
        CatalogManager.checkCatalogInUse(this.store, ident);
        try {
            CatalogManager.CatalogWrapper c = this.catalogManager.loadCatalogAndWrap(ident);
            return fn.apply(c);
        }
        catch (Throwable throwable) {
            if (ex1.isInstance(throwable)) {
                throw (Throwable)ex1.cast(throwable);
            }
            if (ex2.isInstance(throwable)) {
                throw (Throwable)ex2.cast(throwable);
            }
            if (RuntimeException.class.isAssignableFrom(throwable.getClass())) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    protected Set<String> getHiddenPropertyNames(NameIdentifier catalogIdent, ThrowableFunction<HasPropertyMetadata, PropertiesMetadata> provider, Map<String, String> properties) {
        return this.doWithCatalog(catalogIdent, c -> c.doWithPropertiesMeta(p -> {
            PropertiesMetadata propertiesMetadata = (PropertiesMetadata)provider.apply((HasPropertyMetadata)p);
            return properties.keySet().stream().filter(propertiesMetadata::isHiddenProperty).collect(Collectors.toSet());
        }), IllegalArgumentException.class);
    }

    protected <T> void validateAlterProperties(NameIdentifier ident, ThrowableFunction<HasPropertyMetadata, PropertiesMetadata> provider, T ... changes) {
        this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(ident), c -> c.doWithPropertiesMeta(p -> {
            Map<String, String> upserts = this.getPropertiesForSet(changes);
            Map<String, String> deletes = this.getPropertiesForDelete(changes);
            PropertiesMetadataHelpers.validatePropertyForAlter((PropertiesMetadata)provider.apply((HasPropertyMetadata)p), upserts, deletes);
            return null;
        }), IllegalArgumentException.class);
    }

    private <T> Map<String, String> getPropertiesForDelete(T ... t) {
        HashMap properties = Maps.newHashMap();
        for (T item : t) {
            TableChange.RemoveProperty removeProperty;
            if (item instanceof TableChange.RemoveProperty) {
                removeProperty = (TableChange.RemoveProperty)item;
                properties.put(removeProperty.getProperty(), removeProperty.getProperty());
                continue;
            }
            if (item instanceof SchemaChange.RemoveProperty) {
                removeProperty = (SchemaChange.RemoveProperty)item;
                properties.put(removeProperty.getProperty(), removeProperty.getProperty());
                continue;
            }
            if (item instanceof FilesetChange.RemoveProperty) {
                removeProperty = (FilesetChange.RemoveProperty)item;
                properties.put(removeProperty.getProperty(), removeProperty.getProperty());
                continue;
            }
            if (!(item instanceof TopicChange.RemoveProperty)) continue;
            removeProperty = (TopicChange.RemoveProperty)item;
            properties.put(removeProperty.getProperty(), removeProperty.getProperty());
        }
        return properties;
    }

    protected StringIdentifier getStringIdFromProperties(Map<String, String> properties) {
        try {
            StringIdentifier stringId = StringIdentifier.fromProperties(properties);
            if (stringId == null) {
                LOG.warn("String identifier is not set in schema properties, this is because the schema is not created by Gravitino, or the schema is created by Gravitino but the string identifier is removed by the user.");
            }
            return stringId;
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Failed to get string identifier from schema properties: {}, this maybe caused by the same-name string identifier is set by the user with unsupported format.", (Object)e.getMessage());
            return null;
        }
    }

    protected <R extends HasIdentifier> R operateOnEntity(NameIdentifier ident, ThrowableFunction<NameIdentifier, R> fn, String opName, long id) {
        HasIdentifier ret = null;
        try {
            ret = (HasIdentifier)fn.apply(ident);
        }
        catch (NoSuchEntityException e) {
            LOG.error("Entity for {} doesn't exist in Gravitino, this is unexpected if this is created by Gravitino. With this situation the returned object will not contain the metadata from Gravitino", (Object)ident);
        }
        catch (Exception e) {
            LOG.error("Failed to {} entity for {} in Gravitino, with this situation the returned object will not contain the metadata from Gravitino.", new Object[]{opName, ident, e});
        }
        if (ret != null && ret.id() != id) {
            LOG.error("Entity {} with uid {} doesn't match the string identifier in the property {}, this is unexpected if this object is created by Gravitino. This might be due to some operations that are not performed through Gravitino. With this situation the returned object will not contain the metadata from Gravitino", new Object[]{ident, ret.id(), id});
            ret = null;
        }
        return (R)ret;
    }

    boolean isManagedEntity(NameIdentifier catalogIdent, Capability.Scope scope) {
        return this.doWithCatalog(catalogIdent, c -> c.capabilities().managedStorage(scope).supported(), IllegalArgumentException.class);
    }

    protected <E extends Entity & HasIdentifier> E getEntity(NameIdentifier ident, Entity.EntityType type, Class<E> entityClass) {
        try {
            return this.store.get(ident, type, entityClass);
        }
        catch (Exception e) {
            LOG.warn("Failed to {} entity for {} in Gravitino, with this situation the returned object will not contain the metadata from Gravitino.", new Object[]{"get", ident, e.getMessage(), e});
            return null;
        }
    }

    private <T> Map<String, String> getPropertiesForSet(T ... t) {
        HashMap properties = Maps.newHashMap();
        for (T item : t) {
            TableChange.SetProperty setProperty;
            if (item instanceof TableChange.SetProperty) {
                setProperty = (TableChange.SetProperty)item;
                properties.put(setProperty.getProperty(), setProperty.getValue());
                continue;
            }
            if (item instanceof SchemaChange.SetProperty) {
                setProperty = (SchemaChange.SetProperty)item;
                properties.put(setProperty.getProperty(), setProperty.getValue());
                continue;
            }
            if (item instanceof FilesetChange.SetProperty) {
                setProperty = (FilesetChange.SetProperty)item;
                properties.put(setProperty.getProperty(), setProperty.getValue());
                continue;
            }
            if (!(item instanceof TopicChange.SetProperty)) continue;
            setProperty = (TopicChange.SetProperty)item;
            properties.put(setProperty.getProperty(), setProperty.getValue());
        }
        return properties;
    }

    static final class FormattedErrorMessages {
        static final String STORE_OP_FAILURE = "Failed to {} entity for {} in Gravitino, with this situation the returned object will not contain the metadata from Gravitino.";
        static final String STRING_ID_NOT_FOUND = "String identifier is not set in schema properties, this is because the schema is not created by Gravitino, or the schema is created by Gravitino but the string identifier is removed by the user.";
        static final String STRING_ID_PARSE_ERROR = "Failed to get string identifier from schema properties: {}, this maybe caused by the same-name string identifier is set by the user with unsupported format.";
        static final String ENTITY_NOT_FOUND = "Entity for {} doesn't exist in Gravitino, this is unexpected if this is created by Gravitino. With this situation the returned object will not contain the metadata from Gravitino";
        static final String ENTITY_UNMATCHED = "Entity {} with uid {} doesn't match the string identifier in the property {}, this is unexpected if this object is created by Gravitino. This might be due to some operations that are not performed through Gravitino. With this situation the returned object will not contain the metadata from Gravitino";

        FormattedErrorMessages() {
        }
    }
}

